package com.dtyunxi.tcbj.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.LogicInventorySnapCondition;
import com.dtyunxi.tcbj.api.dto.request.LogicInventorySnapDto;
import com.dtyunxi.tcbj.api.dto.request.LogicInventorySnapReqDto;
import com.dtyunxi.tcbj.api.dto.request.SnapUpdateAbnormalDataReqDto;
import com.dtyunxi.tcbj.api.dto.response.LogicInventorySnapCountRespDto;
import com.dtyunxi.tcbj.api.dto.response.LogicInventorySnapRespDto;
import com.dtyunxi.tcbj.api.dto.response.LogicInventorySnapStatusCountRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;
import com.github.pagehelper.PageInfo;

import java.util.List;

/**
* 逻辑仓库存快照表服务接口
*
* @author mc
* @since 2022-10-13
*/
@Api(tags = {"逻辑仓库存快照表服务"})
@FeignClient(
    contextId = "com-dtyunxi-tcbj-api-query-ILogicInventorySnapQueryApi",
    name = "${tcbj.center.report.name:tcbj-center-report}",
    path = "/v1/inventory/snap",
    url = "${tcbj.center.report.api:}"
)
public interface ILogicInventorySnapQueryApi {

    /**
    * 根据id查询逻辑仓库存快照表
    *
    * @param id 逻辑仓库存快照表id
    * @return   逻辑仓库存快照表数据
    */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询逻辑仓库存快照表", notes = "根据id查询逻辑仓库存快照表")
    RestResponse<LogicInventorySnapRespDto> queryById(@PathVariable("id") Long id);

    /**
    * 逻辑仓库存快照表分页数据
    *
    * @param reqDto   逻辑仓库存快照表查询条件
    * @return 逻辑仓库存快照表分页数据
    */
    @PostMapping("/page")
    @ApiOperation(value = "逻辑仓库存快照表分页数据", notes = "根据filter查询条件查询逻辑仓库存快照表数据，filter=LogicInventorySnapReqDto")
    RestResponse<PageInfo<LogicInventorySnapRespDto>> queryByPage(@RequestBody LogicInventorySnapReqDto reqDto);

    @PostMapping("/exportQueryByPage")
    @ApiOperation(value = "导出专用，查询仓储库存快照，过滤ocs、wms结存为0的数据", notes = "导出专用，查询仓储库存快照，过滤ocs、wms结存为0的数据")
    RestResponse<PageInfo<LogicInventorySnapRespDto>> exportQueryByPage(@RequestBody LogicInventorySnapReqDto reqDto);

    /**
     * 逻辑仓库存快照表状态数量统计
     *
     * @param reqDto   逻辑仓库存快照表查询条件
     * @return 逻辑仓库存快照表状态数量统计
     */
    @PostMapping("/count")
    @ApiOperation(value = "逻辑仓库存快照表状态数量统计", notes = "逻辑仓库存快照表状态数量统计")
    RestResponse<LogicInventorySnapStatusCountRespDto> count(@RequestBody LogicInventorySnapReqDto reqDto);

    @PostMapping("/statisticsPage")
    @ApiOperation(value = "进销存列表", notes = "进销存列表")
    RestResponse<PageInfo<LogicInventorySnapRespDto>> queryStatisticsPage(@RequestBody LogicInventorySnapReqDto logicInventorySnapReqDto);

    @PostMapping("/statisticsDetailPage")
    @ApiOperation(value = "进销存详情列表", notes = "进销存详情列表")
    RestResponse<PageInfo<LogicInventorySnapRespDto>> queryStatisticsDetailPage(@RequestBody LogicInventorySnapReqDto logicInventorySnapReqDto);

    @PostMapping("/statisticsCount")
    @ApiOperation(value = "进销存条数统计", notes = "进销存条数统计")
    RestResponse<LogicInventorySnapCountRespDto> queryStatisticsCount(@RequestBody LogicInventorySnapReqDto logicInventorySnapReqDto);

    @PostMapping("/initData")
    @ApiOperation(value = "初始化数据", notes = "初始化数据")
    RestResponse<Void> initData(@RequestBody LogicInventorySnapDto logicInventorySnapDto);

    @PostMapping("/updateAbnormalData")
    @ApiOperation(value = "更新异常数据", notes = "更新异常数据")
    RestResponse<Void> updateAbnormalData(@RequestBody SnapUpdateAbnormalDataReqDto logicInventorySnapReqDto);

    @PostMapping("/wmsBalanceUpdate")
    @ApiOperation(value = "更新库存快照和仓储快照", notes = "更新库存快照和仓储快照")
    RestResponse<Void> wmsBalanceUpdate(@RequestBody LogicInventorySnapDto logicInventorySnapDto);

    /**
     * 逻辑仓库存快照表数据
     *
     * @param reqDto   逻辑仓库存快照表查询条件
     * @return 逻辑仓库存快照表数据
     */
    @PostMapping("/queryByCondition")
    @ApiOperation(value = "逻辑仓库存快照表数据", notes = "逻辑仓库存快照表数据")
    RestResponse<List<LogicInventorySnapRespDto>> queryByCondition(@RequestBody LogicInventorySnapCondition reqDto);
}
