package com.dtyunxi.tcbj.api.dto.constant.enums;

/**
 * 仓储明细导入处理方式
 * @author lius5
 */
public enum OperationStorageEnum {

    SUBTRACT(0,"减少"),
    ADD(1,"增加"),
    ;

    private Integer key;

    private String desc;

    public Integer getKey() {
        return key;
    }

    public void setKey(Integer key) {
        this.key = key;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    OperationStorageEnum(Integer key, String desc) {
        this.key = key;
        this.desc = desc;
    }

    public static OperationStorageEnum keyOfEnum(Integer key){
        for (OperationStorageEnum operationStorageEnum : OperationStorageEnum.values()) {
            if (operationStorageEnum.getKey().equals(key)) {
                return operationStorageEnum;
            }
        }
        return null;
    }
}
