/**
 * @(#) PreemptionRecordReportVO.java 1.0 2022/1/5/005
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.tcbj.api.dto.response;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import javax.validation.Valid;
import lombok.Data;

/**
 * PreemptionRecordReportPageListRespDto
 * @author fengjian
 */
@Data
@ApiModel(value = "PreemptionRecordReportPageListRespDto", description = "")
public class PreemptionRecordReportPageListRespDto implements Serializable {

  @ApiModelProperty(name="createTime", value = "创建时间")
  @JsonProperty("createTime")
  private String createTime = null;


  @ApiModelProperty(name="updateTime", value = "更新时间")
  @JsonProperty("updateTime")
  private String updateTime = null;


  @ApiModelProperty(name="createPerson", value = "创建人")
  @JsonProperty("createPerson")
  private String createPerson = null;


  @ApiModelProperty(name="updatePerson", value = "更新人")
  @JsonProperty("updatePerson")
  private String updatePerson = null;


  @ApiModelProperty(name="id", value = "唯一id")
  @JsonProperty("id")
  private Long id = null;


  @ApiModelProperty(name="statisticsTime", value = "统计时间")
  @JsonProperty("statisticsTime")
  private Date statisticsTime;
  
  @ApiModelProperty(name="documentNo", value = "发货通知单号")
  @JsonProperty("documentNo")
  private String documentNo;
  
  
  @ApiModelProperty(name="goodsLongCode", value = "商品长编码")
  @JsonProperty("goodsLongCode")
  private String goodsLongCode;
  
  
  @ApiModelProperty(name="goodsName", value = "商品名称")
  @JsonProperty("goodsName")
  private String goodsName;
  
  
  @ApiModelProperty(name="batch", value = "批次")
  @JsonProperty("batch")
  private String batch;
  
  
  @ApiModelProperty(name="businessOrderNo", value = "关联业务单号")
  @JsonProperty("businessOrderNo")
  private String businessOrderNo;
  
  
  @ApiModelProperty(name="businessType", value = "业务类型")
  @JsonProperty("businessType")
  private String businessType;
  
  
  @ApiModelProperty(name="logicalWarehouseCode", value = "逻辑仓编码")
  @JsonProperty("logicalWarehouseCode")
  private String logicalWarehouseCode;
  
  
  @ApiModelProperty(name="logicalWarehouseName", value = "逻辑仓名称")
  @JsonProperty("logicalWarehouseName")
  private String logicalWarehouseName;
  
  
  @ApiModelProperty(name="logicalWarehouseId", value = "逻辑仓id")
  @JsonProperty("logicalWarehouseId")
  private String logicalWarehouseId;
  
  
  @Valid 
  @ApiModelProperty(name="preemptNum", value = "预占数量")
  @JsonProperty("preemptNum")
  private BigDecimal preemptNum;
  
  
  @ApiModelProperty(name="cargoRightName", value = "库存组织名称")
  @JsonProperty("cargoRightName")
  private String cargoRightName;
  
  
  @ApiModelProperty(name="cargoRightCode", value = "库存组织编码")
  @JsonProperty("cargoRightCode")
  private String cargoRightCode;
  
  
  @ApiModelProperty(name="cargoRightId", value = "库存组织id")
  @JsonProperty("cargoRightId")
  private String cargoRightId;
  
}

