package com.dtyunxi.tcbj.api.dto.request;

import java.util.Date;
import com.dtyunxi.dto.RequestDto;
import com.dtyunxi.tcbj.api.dto.BaseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;

/**
* 物理仓库存表Eo对象
*
* @author wude
* @since 2022-03-07
*/
@ApiModel(value = "PhysicsInventoryReqDto", description = "物理仓库存表Eo对象")
public class PhysicsInventoryReqDto extends BaseDto {
    /**
     *  仓库ID
     */
    @ApiModelProperty(name = "warehouseId", value = "仓库ID")
    private Long warehouseId;
    /**
    *  仓库编码
    */
    @ApiModelProperty(name = "warehouseCode", value = "仓库编码")
    private String warehouseCode;
    /**
    *  仓库名称
    */
    @ApiModelProperty(name = "warehouseName", value = "仓库名称")
    private String warehouseName;
    /**
     *  商品长编码
     */
    @ApiModelProperty(name = "itemLongCode", value = "商品长编码")
    private String itemLongCode;
    /**
     *  商品名称
     */
    @ApiModelProperty(name = "itemName", value = "商品名称")
    private String itemName;
    /**
    *  批次
    */
    @ApiModelProperty(name = "batch", value = "批次")
    private String batch;
    /**
     *  是否过期
     */
    @ApiModelProperty(name = "expired", value = "是否过期 0否 1是")
    private Integer expired;

    /**
     *  过期开始时间
     */
    @ApiModelProperty(name = "expireBeginTime", value = "过期开始时间")
    private Date expireBeginTime;

    /**
     *  过期结束时间
     */
    @ApiModelProperty(name = "expireEndTime", value = "过期结束时间")
    private Date expireEndTime;
    /**
     *  实际库存大于0
     */
    @ApiModelProperty(name = "positiveBalance", value = "实际库存大于0 0否 1是")
    private Integer positiveBalance;

    public String getWarehouseCode() {
        return warehouseCode;
    }

    public void setWarehouseCode(String warehouseCode) {
        this.warehouseCode = warehouseCode;
    }

    public String getWarehouseName() {
        return warehouseName;
    }

    public void setWarehouseName(String warehouseName) {
        this.warehouseName = warehouseName;
    }

    public String getItemLongCode() {
        return itemLongCode;
    }

    public void setItemLongCode(String itemLongCode) {
        this.itemLongCode = itemLongCode;
    }

    public String getItemName() {
        return itemName;
    }

    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    public String getBatch() {
        return batch;
    }

    public void setBatch(String batch) {
        this.batch = batch;
    }

    public Integer getExpired() {
        return expired;
    }

    public void setExpired(Integer expired) {
        this.expired = expired;
    }

    public Date getExpireBeginTime() {
        return expireBeginTime;
    }

    public void setExpireBeginTime(Date expireBeginTime) {
        this.expireBeginTime = expireBeginTime;
    }

    public Date getExpireEndTime() {
        return expireEndTime;
    }

    public void setExpireEndTime(Date expireEndTime) {
        this.expireEndTime = expireEndTime;
    }

    public Integer getPositiveBalance() {
        return positiveBalance;
    }

    public void setPositiveBalance(Integer positiveBalance) {
        this.positiveBalance = positiveBalance;
    }

    public Long getWarehouseId() {
        return warehouseId;
    }

    public void setWarehouseId(Long warehouseId) {
        this.warehouseId = warehouseId;
    }
}
