package com.dtyunxi.tcbj.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.response.OrderAndStatusRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * @author wenyi
 * @date : 2022/4/24 14:50
 * @since 1.0.0
 */
@Api(tags = {"报表中心：查询订单信息"})
@FeignClient(
        name = "${tcbj.center.report.api.name:tcbj-center-report}",
        path = "/v1/order",
        url = "${tcbj.center.report.api:}"
)
public interface IOrderReportQueryApi {

    /**
     * 根据入参单号查询订单表已取消等状态的订单单号
     *
     * @param orderNos
     */
    @PostMapping(value = {"/queryByOrderNos"}, produces = "application/json")
    @ApiOperation(value = "根据入参单号查询订单表已取消等状态的订单单号", notes = "根据入参单号查询订单表已取消等状态的订单单号")
    RestResponse<List<OrderAndStatusRespDto>> queryByOrderNos(@RequestBody List<String> orderNos);

}
