package com.dtyunxi.tcbj.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.response.ConsignmentOrderDeliveryInfoRespDto;
import com.dtyunxi.tcbj.api.dto.response.ConsignmentOrderReportReDto;
import com.dtyunxi.tcbj.api.dto.response.ConsignmentOrderReportRespDto;
import com.dtyunxi.tcbj.api.dto.response.ConsignmentOrderRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
* 运单服务接口
*
* @author 紫霄
* @since 2023-05-09
*/
@Api(tags = {"运单服务"})
@FeignClient(
    contextId = "com-dtyunxi-tcbj-api-query-IConsignmentOrderQueryApi",
    name = "${tcbj.center.report.api.name:tcbj-center-report}",
    path = "/v1/consignmentOrder",
    url = "${tcbj.center.report.api:}"
)
public interface IConsignmentOrderQueryApi {

    /**
    * 根据id查询运单
    *
    * @param id 运单id
    * @return   运单数据
    */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询运单", notes = "根据id查询运单")
    RestResponse<ConsignmentOrderRespDto> queryById(@PathVariable("id") Long id);

    /**
    * 运单分页数据
    *
    * @param filter   运单查询条件
    * @param pageNum  当前页
    * @param pageSize 页大小
    * @return 运单分页数据
    */
    @GetMapping("/page")
    @ApiOperation(value = "运单分页数据", notes = "根据filter查询条件查询运单数据，filter=ConsignmentOrderReqDto")
    RestResponse<PageInfo<ConsignmentOrderRespDto>> queryByPage(@RequestParam("filter") String filter,
                                                           @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                           @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);

    @PostMapping("/queryPage")
    @ApiOperation(value = "运单列表分页数据", notes = "根据查询条件查询运单数据，ConsignmentOrderQueryReqDto")
    RestResponse<PageInfo<ConsignmentOrderReportRespDto>> queryWaybillListPage(@RequestBody ConsignmentOrderReportReDto dto);

    @PostMapping("/queryDeliveryInfoByBusinessNoList")
    @ApiOperation(value = "根据业务单号查询运单配置信息", notes = "根据业务单号查询运单配置信息")
    RestResponse<List<ConsignmentOrderDeliveryInfoRespDto>> queryDeliveryInfoByBusinessNoList(@RequestBody List<String> businessNoList);

}
