package com.dtyunxi.tcbj.api.dto.response;

import java.util.Date;
import com.dtyunxi.dto.ResponseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import com.dtyunxi.dto.BaseRespDto;

/**
* 企业/法人/组织信息表, 注意 ,不是 us_organization的infoEo对象
*
* @author yuangui
* @since 2022-03-22
*/
@ApiModel(value = "OrganizationInfoRespDto", description = "企业/法人/组织信息表, 注意 ,不是 us_organization的infoEo对象")
public class OrganizationInfoRespDto extends BaseRespDto{
    /**
    *  
    */
    @ApiModelProperty(name = "id", value = "")
    private Long id;
    /**
     *  组织ID
     */
    @ApiModelProperty(name = "orgId", value = "组织ID")
    private Long orgId;
    /**
    *  组织代码
    */
    @ApiModelProperty(name = "orgCode", value = "组织代码")
    private String orgCode;
    /**
    *  组织名称
    */
    @ApiModelProperty(name = "orgName", value = "组织名称")
    private String orgName;
    /**
    *  组织类型
    */
    @ApiModelProperty(name = "orgType", value = "组织类型")
    private String orgType;
    /**
    *  简称
    */
    @ApiModelProperty(name = "simpleName", value = "简称")
    private String simpleName;
    /**
    *  注册资本
    */
    @ApiModelProperty(name = "registeredCapital", value = "注册资本")
    private String registeredCapital;
    /**
    *  成立时间
    */
    @ApiModelProperty(name = "foundingTime", value = "成立时间")
    private Date foundingTime;
    /**
    *  统一社会信用代码
    */
    @ApiModelProperty(name = "creditCode", value = "统一社会信用代码")
    private String creditCode;
    /**
    *  税号
    */
    @ApiModelProperty(name = "taxNo", value = "税号")
    private String taxNo;
    /**
    *  组织机构代码
    */
    @ApiModelProperty(name = "orgCertNo", value = "组织机构代码")
    private String orgCertNo;
    /**
    *  营业执照编号
    */
    @ApiModelProperty(name = "businessLicenseNo", value = "营业执照编号")
    private String businessLicenseNo;
    /**
    *  公司地址
    */
    @ApiModelProperty(name = "address", value = "公司地址")
    private String address;
    /**
    *  联系电话
    */
    @ApiModelProperty(name = "phoneNum", value = "联系电话")
    private String phoneNum;
    /**
    *  银行开户名
    */
    @ApiModelProperty(name = "accountName", value = "银行开户名")
    private String accountName;
    /**
    *  银行账户号
    */
    @ApiModelProperty(name = "accountNum", value = "银行账户号")
    private String accountNum;
    /**
    *  开户行支行名称
    */
    @ApiModelProperty(name = "branchAccountName", value = "开户行支行名称")
    private String branchAccountName;
    /**
    *  开户行职场联行号
    */
    @ApiModelProperty(name = "branchAccountNum", value = "开户行职场联行号")
    private String branchAccountNum;
    /**
    *  经营范围
    */
    @ApiModelProperty(name = "busiScope", value = "经营范围")
    private String busiScope;
    /**
    *  公司邮箱
    */
    @ApiModelProperty(name = "companyEmail", value = "公司邮箱")
    private String companyEmail;
    /**
    *  公司电话
    */
    @ApiModelProperty(name = "companyTel", value = "公司电话")
    private String companyTel;
    /**
    *  fax
    */
    @ApiModelProperty(name = "fax", value = "fax")
    private String fax;
    /**
    *  法人证件号码
    */
    @ApiModelProperty(name = "legalCardNum", value = "法人证件号码")
    private String legalCardNum;
    /**
    *  法人证件身份证
    */
    @ApiModelProperty(name = "legalManCard", value = "法人证件身份证")
    private String legalManCard;
    /**
    *  法人代表
    */
    @ApiModelProperty(name = "legalName", value = "法人代表")
    private String legalName;
    /**
    *  联系人
    */
    @ApiModelProperty(name = "linkman", value = "联系人")
    private String linkman;
    /**
    *  邮编
    */
    @ApiModelProperty(name = "postcode", value = "邮编")
    private String postcode;
    /**
    *  营业执照图片url
    */
    @ApiModelProperty(name = "bussinessLicenseUrl", value = "营业执照图片url")
    private String bussinessLicenseUrl;
    /**
    *  公司logo
    */
    @ApiModelProperty(name = "logoUrl", value = "公司logo")
    private String logoUrl;
    /**
    *  员工数量
    */
    @ApiModelProperty(name = "staffNum", value = "员工数量")
    private String staffNum;
    /**
    *  身份证反面
    */
    @ApiModelProperty(name = "idCardBack", value = "身份证反面")
    private String idCardBack;
    /**
    *  身份证正面
    */
    @ApiModelProperty(name = "idCardFront", value = "身份证正面")
    private String idCardFront;
    /**
    *  
    */
    @ApiModelProperty(name = "userId", value = "")
    private Long userId;
    /**
    *  
    */
    @ApiModelProperty(name = "personId", value = "")
    private Long personId;
    /**
    *  执照类型,1:多证合一营业执照,2:普通营业执照
    */
    @ApiModelProperty(name = "businessLicenseType", value = "执照类型,1:多证合一营业执照,2:普通营业执照")
    private Integer businessLicenseType;
    /**
    *  营业期限类型,1:短期有效，2：长期有效
    */
    @ApiModelProperty(name = "businessTermType", value = "营业期限类型,1:短期有效，2：长期有效")
    private Integer businessTermType;
    /**
    *  营业期限开始时间
    */
    @ApiModelProperty(name = "termBeginTime", value = "营业期限开始时间")
    private Date termBeginTime;
    /**
    *  营业期限结束时间
    */
    @ApiModelProperty(name = "termEndTime", value = "营业期限结束时间")
    private Date termEndTime;
    /**
    *  法人证件有效期类型，1:短期有效，2：长期有效
    */
    @ApiModelProperty(name = "cardEffectType", value = "法人证件有效期类型，1:短期有效，2：长期有效")
    private String cardEffectType;
    /**
    *  法人证件有效期开始时间
    */
    @ApiModelProperty(name = "cardEffectBeginTime", value = "法人证件有效期开始时间")
    private Date cardEffectBeginTime;
    /**
    *  法人证件有效期结束时间
    */
    @ApiModelProperty(name = "cardEffectEndTime", value = "法人证件有效期结束时间")
    private Date cardEffectEndTime;
    /**
    *  法人证件类型,1:大陆居民省份证，2：港澳台，3：护照
    */
    @ApiModelProperty(name = "legalCardType", value = "法人证件类型,1:大陆居民省份证，2：港澳台，3：护照")
    private Integer legalCardType;
    /**
    *  经营资质
    */
    @ApiModelProperty(name = "businessQualification", value = "经营资质")
    private String businessQualification;
    /**
    *  主体类型（company：企业，individual：个体户，zooid：个人）
    */
    @ApiModelProperty(name = "subjectType", value = "主体类型（company：企业，individual：个体户，zooid：个人）")
    private String subjectType;

    public void setId(Long id){
    this.id = id;
    }
    public Long getId(){
    return this.id;
    }
    public void setOrgCode(String orgCode){
    this.orgCode = orgCode;
    }
    public String getOrgCode(){
    return this.orgCode;
    }
    public void setOrgName(String orgName){
    this.orgName = orgName;
    }
    public String getOrgName(){
    return this.orgName;
    }
    public void setOrgType(String orgType){
    this.orgType = orgType;
    }
    public String getOrgType(){
    return this.orgType;
    }
    public void setSimpleName(String simpleName){
    this.simpleName = simpleName;
    }
    public String getSimpleName(){
    return this.simpleName;
    }
    public void setRegisteredCapital(String registeredCapital){
    this.registeredCapital = registeredCapital;
    }
    public String getRegisteredCapital(){
    return this.registeredCapital;
    }
    public void setFoundingTime(Date foundingTime){
    this.foundingTime = foundingTime;
    }
    public Date getFoundingTime(){
    return this.foundingTime;
    }
    public void setCreditCode(String creditCode){
    this.creditCode = creditCode;
    }
    public String getCreditCode(){
    return this.creditCode;
    }
    public void setTaxNo(String taxNo){
    this.taxNo = taxNo;
    }
    public String getTaxNo(){
    return this.taxNo;
    }
    public void setOrgCertNo(String orgCertNo){
    this.orgCertNo = orgCertNo;
    }
    public String getOrgCertNo(){
    return this.orgCertNo;
    }
    public void setBusinessLicenseNo(String businessLicenseNo){
    this.businessLicenseNo = businessLicenseNo;
    }
    public String getBusinessLicenseNo(){
    return this.businessLicenseNo;
    }
    public void setAddress(String address){
    this.address = address;
    }
    public String getAddress(){
    return this.address;
    }
    public void setPhoneNum(String phoneNum){
    this.phoneNum = phoneNum;
    }
    public String getPhoneNum(){
    return this.phoneNum;
    }
    public void setAccountName(String accountName){
    this.accountName = accountName;
    }
    public String getAccountName(){
    return this.accountName;
    }
    public void setAccountNum(String accountNum){
    this.accountNum = accountNum;
    }
    public String getAccountNum(){
    return this.accountNum;
    }
    public void setBranchAccountName(String branchAccountName){
    this.branchAccountName = branchAccountName;
    }
    public String getBranchAccountName(){
    return this.branchAccountName;
    }
    public void setBranchAccountNum(String branchAccountNum){
    this.branchAccountNum = branchAccountNum;
    }
    public String getBranchAccountNum(){
    return this.branchAccountNum;
    }
    public void setBusiScope(String busiScope){
    this.busiScope = busiScope;
    }
    public String getBusiScope(){
    return this.busiScope;
    }
    public void setCompanyEmail(String companyEmail){
    this.companyEmail = companyEmail;
    }
    public String getCompanyEmail(){
    return this.companyEmail;
    }
    public void setCompanyTel(String companyTel){
    this.companyTel = companyTel;
    }
    public String getCompanyTel(){
    return this.companyTel;
    }
    public void setFax(String fax){
    this.fax = fax;
    }
    public String getFax(){
    return this.fax;
    }
    public void setLegalCardNum(String legalCardNum){
    this.legalCardNum = legalCardNum;
    }
    public String getLegalCardNum(){
    return this.legalCardNum;
    }
    public void setLegalManCard(String legalManCard){
    this.legalManCard = legalManCard;
    }
    public String getLegalManCard(){
    return this.legalManCard;
    }
    public void setLegalName(String legalName){
    this.legalName = legalName;
    }
    public String getLegalName(){
    return this.legalName;
    }
    public void setLinkman(String linkman){
    this.linkman = linkman;
    }
    public String getLinkman(){
    return this.linkman;
    }
    public void setPostcode(String postcode){
    this.postcode = postcode;
    }
    public String getPostcode(){
    return this.postcode;
    }
    public void setBussinessLicenseUrl(String bussinessLicenseUrl){
    this.bussinessLicenseUrl = bussinessLicenseUrl;
    }
    public String getBussinessLicenseUrl(){
    return this.bussinessLicenseUrl;
    }
    public void setLogoUrl(String logoUrl){
    this.logoUrl = logoUrl;
    }
    public String getLogoUrl(){
    return this.logoUrl;
    }
    public void setStaffNum(String staffNum){
    this.staffNum = staffNum;
    }
    public String getStaffNum(){
    return this.staffNum;
    }
    public void setIdCardBack(String idCardBack){
    this.idCardBack = idCardBack;
    }
    public String getIdCardBack(){
    return this.idCardBack;
    }
    public void setIdCardFront(String idCardFront){
    this.idCardFront = idCardFront;
    }
    public String getIdCardFront(){
    return this.idCardFront;
    }
    public void setUserId(Long userId){
    this.userId = userId;
    }
    public Long getUserId(){
    return this.userId;
    }
    public void setPersonId(Long personId){
    this.personId = personId;
    }
    public Long getPersonId(){
    return this.personId;
    }
    public void setBusinessLicenseType(Integer businessLicenseType){
    this.businessLicenseType = businessLicenseType;
    }
    public Integer getBusinessLicenseType(){
    return this.businessLicenseType;
    }
    public void setBusinessTermType(Integer businessTermType){
    this.businessTermType = businessTermType;
    }
    public Integer getBusinessTermType(){
    return this.businessTermType;
    }
    public void setTermBeginTime(Date termBeginTime){
    this.termBeginTime = termBeginTime;
    }
    public Date getTermBeginTime(){
    return this.termBeginTime;
    }
    public void setTermEndTime(Date termEndTime){
    this.termEndTime = termEndTime;
    }
    public Date getTermEndTime(){
    return this.termEndTime;
    }
    public void setCardEffectType(String cardEffectType){
    this.cardEffectType = cardEffectType;
    }
    public String getCardEffectType(){
    return this.cardEffectType;
    }
    public void setCardEffectBeginTime(Date cardEffectBeginTime){
    this.cardEffectBeginTime = cardEffectBeginTime;
    }
    public Date getCardEffectBeginTime(){
    return this.cardEffectBeginTime;
    }
    public void setCardEffectEndTime(Date cardEffectEndTime){
    this.cardEffectEndTime = cardEffectEndTime;
    }
    public Date getCardEffectEndTime(){
    return this.cardEffectEndTime;
    }
    public void setLegalCardType(Integer legalCardType){
    this.legalCardType = legalCardType;
    }
    public Integer getLegalCardType(){
    return this.legalCardType;
    }
    public void setBusinessQualification(String businessQualification){
    this.businessQualification = businessQualification;
    }
    public String getBusinessQualification(){
    return this.businessQualification;
    }
    public void setSubjectType(String subjectType){
    this.subjectType = subjectType;
    }
    public String getSubjectType(){
    return this.subjectType;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
}
