package com.dtyunxi.tcbj.api.dto.response;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.Valid;
import java.math.BigDecimal;

/**
 * 销售订单统计dto
 *
 * @author haoxiao
 * @since 2022-03-10
 */
@Data
@ApiModel(value = "SaleOrderCountRespDto", description = "读码结果统计")
public class SaleOrderStringCodeCountRespDto {

    @Valid
    @ApiModelProperty(name="allCount", value = "全部数量")
    @JsonProperty("allCount")
    private BigDecimal allCount;


    @Valid
    @ApiModelProperty(name="notReadCount", value = "未读取")
    @JsonProperty("notReadCount")
    private BigDecimal notReadCount;


    @Valid
    @ApiModelProperty(name="v", value = "读码异常")
    @JsonProperty("readFail")
    private BigDecimal readFail;

    @Valid
    @ApiModelProperty(name="readSuccess", value = "读码成功")
    @JsonProperty("readSuccess")
    private BigDecimal readSuccess;
}
