package com.dtyunxi.tcbj.api.dto.request;

import com.dtyunxi.tcbj.api.dto.entity.BasePageDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
* 逻辑仓库存快照表Eo对象
*
* @author mc
* @since 2022-10-13
*/
@Getter
@Setter
@ApiModel(value = "LogicInventorySnapReqDto", description = "逻辑仓库存快照表Eo对象")
public class LogicInventorySnapReqDto extends BasePageDto {
    @ApiModelProperty(name = "id", value = "主键ID")
    private Long id;
    /**
    *  仓库ID
    */
    @ApiModelProperty(name = "warehouseId", value = "仓库ID")
    private Long warehouseId;
    /**
    *  仓库编码
    */
    @ApiModelProperty(name = "warehouseCode", value = "仓库编码")
    private String warehouseCode;
    /**
     *  物理仓库编码
     */
    @ApiModelProperty(name = "physicsWarehouseCode", value = "物理仓库编码")
    private String physicsWarehouseCode;

    @ApiModelProperty(name = "physicsWarehouseCodeList", value = "物理仓库编码")
    private List<String> physicsWarehouseCodeList;
    /**
     *  物理仓库编码
     */
    @ApiModelProperty(name = "physicsWarehouseName", value = "物理仓库编码")
    private String physicsWarehouseName;
    /**
     *  库存组织编码
     */
    @ApiModelProperty(name = "organizationCode", value = "库存组织编码")
    private String organizationCode;
    /**
     *  库存组织名称
     */
    @ApiModelProperty(name = "organizationName", value = "库存组织名称")
    private String organizationName;
    /**
    *  仓库名称
    */
    @ApiModelProperty(name = "warehouseName", value = "仓库名称")
    private String warehouseName;
    /**
    *  统计时间
    */
    @ApiModelProperty(name = "statisticalTime", value = "统计时间")
    private String statisticalTime;

    /**
     *  统计时间
     */
    @ApiModelProperty(name = "statisticalTimeStarter", value = "统计时间开始")
    private String statisticalTimeStarter;

    /**
     *  统计时间
     */
    @ApiModelProperty(name = "statisticalTimeEnd", value = "统计时间结束")
    private String statisticalTimeEnd;
    /**
    *  货品ID
    */
    @ApiModelProperty(name = "cargoId", value = "货品ID")
    private Long cargoId;
    /**
    *  商品长编码
    */
    @ApiModelProperty(name = "longCode", value = "商品长编码")
    private String longCode;
    /**
    *  货品名称
    */
    @ApiModelProperty(name = "cargoName", value = "货品名称")
    private String cargoName;

    @ApiModelProperty(name = "batch", value = "批次")
    private String batch;

    @ApiModelProperty(name = "abnormal", value = "是否异常，1-是,0-否")
    private String abnormal;

    @ApiModelProperty(name = "abnormalCauses", value = "异常原因")
    private String abnormalCauses;

//    @ApiModelProperty(name = "wmsBalance", value = "wms期末库存")
//    private BigDecimal wmsBalance;

    @ApiModelProperty(name = "balance", value = "计费库存（期末库存）")
    private BigDecimal balance;
    @ApiModelProperty(name = "trayNum", value = "码托数")
    private Long trayNum;
    @ApiModelProperty(name = "bigBox", value = "大箱数")
    private Integer bigBox;
    @ApiModelProperty(name = "remark", value = "备注")
    private String remark;
    @ApiModelProperty(name = "status", value = "状态：全部-0、正常-1、wms多-2，wms少-3，数据异常-4")
    private Integer status;
}
