package com.dtyunxi.tcbj.api.dto.request;

import java.util.Date;
import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

/**
* 仓储费用分摊明细表Eo对象
*
* @author by_liusong
* @since 2022-07-15
*/
@ApiModel(value = "StorageChargeApportionDetailReqDto", description = "仓储费用分摊明细表Eo对象")
@Data
public class StorageChargeApportionDetailReqDto extends RequestDto{
    /**
    *  主键
    */
    @ApiModelProperty(name = "id", value = "主键")
    private Long id;
    /**
    *  关联分摊主表ID
    */
    @ApiModelProperty(name = "apportionId", value = "关联分摊主表ID")
    private Long apportionId;
    /**
    *  统计数据月份
    */
    @ApiModelProperty(name = "recordMonth", value = "统计数据月份")
    private Date recordMonth;

    /**
     * 统计数据月份
     */
    @ApiModelProperty(name = "startRecordMonth", value = "统计数据开始月份")
    private Date startRecordMonth;

    /**
     * 统计数据月份
     */
    @ApiModelProperty(name = "endRecordMonth", value = "统计数据结束月份")
    private Date endRecordMonth;
    /**
    *  账单统计日期
    */
    @ApiModelProperty(name = "billTime", value = "账单统计日期")
    private Date billTime;
    /**
    *  仓库编码
    */
    @ApiModelProperty(name = "warehouseCode", value = "仓库编码")
    private String warehouseCode;
    /**
    *  仓库名称
    */
    @ApiModelProperty(name = "warehouseName", value = "仓库名称")
    private String warehouseName;

    private List<String> warehouseCodeList;
    /**
    *  商品长编码
    */
    @ApiModelProperty(name = "opLongCode", value = "商品长编码")
    private String opLongCode;
    /**
    *  商品名称
    */
    @ApiModelProperty(name = "itemName", value = "商品名称")
    private String itemName;
    /**
    *  批次
    */
    @ApiModelProperty(name = "batch", value = "批次")
    private String batch;
    /**
    *  分摊起始时间
    */
    @ApiModelProperty(name = "apportionStartTime", value = "分摊起始时间")
    private Date apportionStartTime;
    /**
    *  分摊结束时间
    */
    @ApiModelProperty(name = "apportionEndTime", value = "分摊结束时间")
    private Date apportionEndTime;
    /**
    *  分摊总数
    */
    @ApiModelProperty(name = "apportionAllNum", value = "分摊总数")
    private Integer apportionAllNum;
    /**
    *  分摊数
    */
    @ApiModelProperty(name = "apportionNum", value = "分摊数")
    private Integer apportionNum;
    /**
    *  分摊板数
    */
    @ApiModelProperty(name = "apportionSupport", value = "分摊板数")
    private BigDecimal apportionSupport;
    /**
    *  货权归属组织id
    */
    @ApiModelProperty(name = "belongOrgId", value = "货权归属组织id")
    private Long belongOrgId;
    /**
    *  货权归属组织名称
    */
    @ApiModelProperty(name = "belongOrgName", value = "货权归属组织名称")
    private String belongOrgName;
    /**
    *  分摊逻辑仓编码
    */
    @ApiModelProperty(name = "apportionLogicWarehouseCode", value = "分摊逻辑仓编码")
    private String apportionLogicWarehouseCode;
    /**
    *  分摊逻辑仓名称
    */
    @ApiModelProperty(name = "apportionLogicWarehouseName", value = "分摊逻辑仓名称")
    private String apportionLogicWarehouseName;

    /**
     *  分摊库存组织id
     */
    @ApiModelProperty(name = "apportionOrgId", value = "分摊库存组织id")
    private Long apportionOrgId;
    /**
     *  分摊库存组织名称
     */
    @ApiModelProperty(name = "apportionOrgName", value = "分摊库存组织名称")
    private String apportionOrgName;
    /**
    *  分摊操作人
    */
    @ApiModelProperty(name = "apportionOperator", value = "分摊操作人")
    private String apportionOperator;

    private Integer pageNum;
    private Integer pageSize;


}
