package com.dtyunxi.tcbj.api.dto.request;

import com.dtyunxi.dto.RequestDto;
import com.yunxi.dg.base.commons.dto.BaseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import liquibase.pro.packaged.S;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 物流计费明细DTO
 */
@Setter
@Getter
@ApiModel(value = "FinLogisticDetailChargingDto", description = "物流计费明细DTO")
public class FinLogisticDetailChargingDto extends BaseDto {

    @ApiModelProperty(name = "ids", value = "主键集合")
    private List<Long> ids;

    @ApiModelProperty(name = "bookkeepingDate", value = "记账日期")
    private String bookkeepingDate;

    @ApiModelProperty(name = "billingDate", value = "开单日期")
    private String billingDate;

    @ApiModelProperty(name = "easNo", value = "eas单号")
    private String easNo;

    @ApiModelProperty(name = "reportId", value = "物流费合计id")
    private String reportId;

    @ApiModelProperty(name = "type", value = "类型")
    private String type;

    @ApiModelProperty(name = "businessType", value = "业务类型")
    private String businessType;

    private List<String> businessTypeList;

    @ApiModelProperty(name = "contractOilPrice", value = "合同基准油价")
    private BigDecimal contractOilPrice;
    /**
     * 油价幅度
     */
    @ApiModelProperty(name = "rangeOilPrice", value = "油价幅度")
    private String rangeOilPrice;
    /**
     * 联动油价
     */
    @ApiModelProperty(name = "linkOilPrice", value = "联动油价")
    private BigDecimal linkOilPrice;
    /**
     * 运费调整幅度
     */
    @ApiModelProperty(name = "adjustOilPrice", value = "运费调整幅度")
    private BigDecimal adjustOilPrice;
    /**
     *  出库时间
     */
    @ApiModelProperty(name = "outboundTime", value = "出库时间")
    private Date outboundTime;

    @ApiModelProperty(name = "outboundTimeStart", value = "出库时间开始")
    private Date outboundTimeStart;

    @ApiModelProperty(name = "outboundTimeEnd", value = "出库时间结束")
    private Date outboundTimeEnd;

    /**
     *  出库通知单号
     */
    @ApiModelProperty(name = "outNoticeCode", value = "出库通知单号")
    private String outNoticeCode;
    /**
     *  出库结果单号
     */
    @ApiModelProperty(name = "outResultCode", value = "出库结果单号")
    private String outResultCode;

    /**
     *  出库单号
     */
    @ApiModelProperty(name = "outboundCode", value = "出库单号")
    private String outboundCode;
    /**
     *  wms出库单号
     */
    @ApiModelProperty(name = "wmsOutboundCode", value = "wms出库单号")
    private String wmsOutboundCode;
    /**
     *  wms合单号
     */
    @ApiModelProperty(name = "wmsMergeDocumentNo", value = "wms合单号")
    private String wmsMergeDocumentNo;
    /**
     *  关联业务单号
     */
    @ApiModelProperty(name = "businessCode", value = "关联业务单号")
    private String businessCode;

    @ApiModelProperty(name = "warehouseName", value = "出库物理仓名称")
    private String warehouseName;

    @ApiModelProperty(name = "warehouseCode", value = "出库物理仓编码")
    private String warehouseCode;

    @ApiModelProperty(name = "warehouseCodeList", value = "出库物理仓编码集合")
    private List<String> warehouseCodeList;
    /**
     *  物流公司
     */
    @ApiModelProperty(name = "logisticCompany", value = "物流公司")
    private String logisticCompany;
    /**
     *  承运方式
     */
    @ApiModelProperty(name = "transportType", value = "承运方式")
    private String transportType;
    @ApiModelProperty(name = "transportTypeList", value = "承运方式集合")
    private List<String> transportTypeList;
    /**
     *  托运单号
     */
    @ApiModelProperty(name = "transportCode", value = "托运单号")
    private String transportCode;
    /**
     *  承运单号
     */
    @ApiModelProperty(name = "transportNo", value = "承运单号")
    private String transportNo;
    /**
     *  瓶数
     */
    @ApiModelProperty(name = "bottle", value = "瓶数")
    private BigDecimal bottle;
    /**
     *  箱数
     */
    @ApiModelProperty(name = "box", value = "箱数")
    private BigDecimal box;
    /**
     *  体积（m^3）
     */
    @ApiModelProperty(name = "volume", value = "体积（m^3）")
    private BigDecimal volume;
    /**
     *  重量（KG）
     */
    @ApiModelProperty(name = "weight", value = "重量（KG）")
    private BigDecimal weight;
    /**
     *  累计箱数
     */
    @ApiModelProperty(name = "totalBox", value = "累计箱数")
    private BigDecimal totalBox;
    /**
     *  累计体积（m^3）
     */
    @ApiModelProperty(name = "totalVolume", value = "累计体积（m^3）")
    private BigDecimal totalVolume;
    /**
     *  累计重量（KG）
     */
    @ApiModelProperty(name = "totalWeight", value = "累计重量（KG）")
    private BigDecimal totalWeight;
    /**
     *  计算方式
     */
    @ApiModelProperty(name = "chargeMode", value = "计算方式")
    private String chargeMode;
    /**
     *  计算方式
     */
    @ApiModelProperty(name = "chargeModeName", value = "计算方式名称")
    private String chargeModeName;
    /**
     *  运费单价
     */
    @ApiModelProperty(name = "transportPrice", value = "运费单价")
    private BigDecimal transportPrice;
    /**
     *  运费金额
     */
    @ApiModelProperty(name = "transportAmount", value = "运费金额")
    private BigDecimal transportAmount;
    /**
     *  最低费用
     */
    @ApiModelProperty(name = "minCharge", value = "最低费用")
    private BigDecimal minCharge;
    /**
     *  送货费
     */
    @ApiModelProperty(name = "deliveryAmount", value = "送货费")
    private BigDecimal deliveryAmount;
    /**
     *  卸货费
     */
    @ApiModelProperty(name = "unloadAmount", value = "卸货费")
    private BigDecimal unloadAmount;
    /**
     *  油价联动
     */
    @ApiModelProperty(name = "oilPrice", value = "油价联动")
    private BigDecimal oilPrice;
    /**
     * 油价总金额
     */
    @ApiModelProperty(name = "oilTotalPrice", value = "油价总金额")
    private BigDecimal oilTotalPrice;
    /**
     *  特殊费用类型
     */
    @ApiModelProperty(name = "specialType", value = "特殊费用类型")
    private String specialType;
    /**
     *  特殊费用
     */
    @ApiModelProperty(name = "specialAmount", value = "特殊费用")
    private BigDecimal specialAmount;
    /**
     *  运费合计
     */
    @ApiModelProperty(name = "totalTransportAmount", value = "运费合计")
    private BigDecimal totalTransportAmount;
    /**
     *  分摊费用
     */
    @ApiModelProperty(name = "shareAmount", value = "分摊费用")
    private BigDecimal shareAmount;
    /**
     *  调出仓库
     */
    @ApiModelProperty(name = "warehouseOut", value = "调出仓库")
    private String warehouseOut;
    /**
     *  调出组织
     */
    @ApiModelProperty(name = "organizationOut", value = "调出组织")
    private String organizationOut;
    /**
     *  调出组织
     */
    @ApiModelProperty(name = "organizationOutList", value = "调出组织集合")
    private List<String> organizationOutList;
    /**
     *  调入仓库
     */
    @ApiModelProperty(name = "warehouseEnter", value = "调入仓库")
    private String warehouseEnter;
    /**
     *  调入组织
     */
    @ApiModelProperty(name = "organizationEnter", value = "调入组织")
    private String organizationEnter;
    /**
     *  调入组织
     */
    @ApiModelProperty(name = "organizationEnterList", value = "调入组织集合")
    private List<String> organizationEnterList;
    /**
     *  收货人
     */
    @ApiModelProperty(name = "harvestPeople", value = "收货人")
    private String harvestPeople;

    @ApiModelProperty(name = "province", value = "省份")
    private String province;

    @ApiModelProperty(name = "provinceCode", value = "省份Code")
    private String provinceCode;

    @ApiModelProperty(name = "city", value = "城市")
    private String city;

    @ApiModelProperty(name = "cityCode", value = "城市Code")
    private String cityCode;

    @ApiModelProperty(name = "cityLevel", value = "城市级别")
    private String cityLevel;

    @ApiModelProperty(name = "area", value = "区域")
    private String area;

    @ApiModelProperty(name = "areaCode", value = "区域Code")
    private String areaCode;

    @ApiModelProperty(name = "harvestAddress", value = "客户收货地址")
    private String harvestAddress;

    @ApiModelProperty(name = "customerName", value = "客户名称")
    private String customerName;

    @ApiModelProperty(name = "lngLat", value = "经纬度,以,分割")
    private String lngLat;

    @ApiModelProperty(name = "status", value = "状态（0=正常 1=异常）")
    private Integer status;

    @ApiModelProperty(name = "abnormalCauses", value = "异常原因")
    private String abnormalCauses;

    @ApiModelProperty(name = "remark", value = "备注")
    private String remark;

    @ApiModelProperty(name = "mergeCode", value = "合单编码")
    private String mergeCode;

    @ApiModelProperty(name = "mergeCodeList", value = "合单编码集合")
    private List<String> mergeCodeList;

    @ApiModelProperty(name = "calUnitName", value = "精准计费方式")
    private String calUnitName;

    @ApiModelProperty(name = "linkDailyReportId", value = "关联每日发货报表记录id")
    private Long linkDailyReportId;

    @ApiModelProperty(name = "placedFlag", value = "是否已归档,0未归档,1已归档")
    private Integer placedFlag;

    @ApiModelProperty(name = "billingFeeFlag", value = "是否计费,0不计费,1计费")
    private Integer billingFeeFlag;

    @ApiModelProperty(name = "noBillingReason", value = "不计费原因")
    private String noBillingReason;

    @ApiModelProperty(name = "shopName", value = "店铺名称")
    private String shopName;

    @ApiModelProperty(name = "shopCode", value = "店铺编码")
    private String shopCode;

    @ApiModelProperty(name = "logisticCompanyCode", value = "物流公司编码")
    private String logisticCompanyCode;

    @ApiModelProperty(name = "logisticCompanyCodeList", value = "物流公司编码集合")
    private List<String> logisticCompanyCodeList;

    @ApiModelProperty(name = "logisticsModeId", value = "物流费用模板")
    private Long logisticsModeId;

    @ApiModelProperty(name = "logisticsTemplateArea", value = "物流模版区域")
    private String logisticsTemplateArea;

    @ApiModelProperty(name = "logisticsTemplateId", value = "物流模版ID")
    private Long logisticsTemplateId;


    private String warehouseOutCode;
    private List<String> warehouseOutCodeList;

    private String warehouseEnterCode;
    private List<String> warehouseEnterCodeList;

    @ApiModelProperty(name = "feeId", value = "费用ID")
    private Long feeId;

    @ApiModelProperty(name = "billType", value = "计费类型")
    private String billType;

    @ApiModelProperty(name = "billTypeStr", value = "计费类型Str")
    private String billTypeStr;

    @ApiModelProperty(name = "billTypeList", value = "计费类型集合")
    private List<String> billTypeList;

    @ApiModelProperty(name = "apportionNum", value = "分摊数量")
    private BigDecimal apportionNum;

    @ApiModelProperty(name = "apportionVolume", value = "分摊体积")
    private BigDecimal apportionVolume;

    @ApiModelProperty(name = "apportionWeight", value = "分摊重量")
    private BigDecimal apportionWeight;

//    @ApiModelProperty(name = "apportionTransportAmount", value = "分摊运费")
//    private BigDecimal apportionTransportAmount;

//    @ApiModelProperty(name = "orgTotalTransportAmount", value = "组织运费合计")
//    private BigDecimal orgTotalTransportAmount;

    private Integer pageSize;
    private Integer pageNum;

    @ApiModelProperty(name = "billingOrgCode", value = "计费组织编码")
    private String billingOrgCode;
    @ApiModelProperty(name = "billingOrgCodeList", value = "计费组织编码集合")
    private List<String> billingOrgCodeList;

    @ApiModelProperty(name = "billingOrgName", value = "计费组织名称")
    private String billingOrgName;

    @ApiModelProperty(name = "total", value = "全部数量")
    private BigDecimal total;
    @ApiModelProperty(name = "unusualTotal", value = "异常数量")
    private BigDecimal unusualTotal;
    @ApiModelProperty(name = "normalTotal", value = "正常数量")
    private BigDecimal normalTotal;
    @ApiModelProperty(name = "countVolume", value = "统计体积")
    private BigDecimal countVolume;
    @ApiModelProperty(name = "countWeight", value = "统计重量")
    private BigDecimal countWeight;
    @ApiModelProperty(name = "countBox", value = "统计箱数")
    private BigDecimal countBox;
    @ApiModelProperty(name = "countTransportAmount", value = "统计物流运费")
    private BigDecimal countTransportAmount;

    @ApiModelProperty(name = "ifDelFormer", value = "生成数据时，是否需要删除久数据")
    private boolean ifDelFormer = false;

    //组织运费合计
    private BigDecimal orgTotalTransportAmount;


}
