package com.dtyunxi.tcbj.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.ExpressCostReportReqDto;
import com.dtyunxi.tcbj.api.dto.response.ExpressCostReportRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;

/**
* 快递费用报表服务接口
*
* @author 天泽
* @since 2022-11-17
*/
@Api(tags = {"快递费用报表服务"})
@FeignClient(
    contextId = "com-dtyunxi-tcbj-api-IExpressCostReportApi",
    name = "${tcbj.center.report.api.name:tcbj-center-report}",
    path = "/v1/express/cost/report",
    url = "${tcbj.center.report.api:}"
)
public interface IExpressCostReportApi {

/**
* 新增快递费用报表
*
* @param addReqDto 快递费用报表请求对象
* @return 处理结果
*/
@PostMapping("")
@ApiOperation(value = "新增快递费用报表", notes = "新增快递费用报表")
RestResponse<Long> addExpressCostReport(@RequestBody ExpressCostReportReqDto addReqDto);

    /**
    * 修改快递费用报表
    *
    * @param modifyReqDto 快递费用报表请求对象
    * @return 处理结果
    */
    @PutMapping("")
    @ApiOperation(value = "修改快递费用报表", notes = "修改快递费用报表")
    RestResponse<Void> modifyExpressCostReport(@RequestBody ExpressCostReportReqDto modifyReqDto);

    /**
    * 删除快递费用报表
    *
    * @param ids        快递费用报表删除数据ID
    * @param instanceId 实例ID
    * @return 处理结果
    */
    @DeleteMapping("/{ids}")
    @ApiOperation(value = "删除快递费用报表", notes = "删除快递费用报表")
    RestResponse<Void> removeExpressCostReport(@PathVariable("ids") String ids, @RequestParam("instanceId") Long instanceId);
}
