package com.dtyunxi.tcbj.api.dto.constant;

import org.apache.commons.lang3.StringUtils;

/**
 * 保费账单计费类型枚举
 */
public enum ReInsuranceBillTypeEnum {

    T01("T01","常规计费"),
    T02("T02","人工分摊"),
    T03("T03","内部交易"),
    T04("T04","在途内部交易"),
    T05("T05","分货调拨"),

    ;
    private final String code;
    private final String name;

    ReInsuranceBillTypeEnum(String code, String name) {
        this.code = code;
        this.name = name;
    }

    public String getCode() {
        return code;
    }

    public String getName() {
        return name;
    }

    public static String getNameByCode(String code) {
        if (StringUtils.isBlank(code)){
            return code;
        }
        for (ReInsuranceBillTypeEnum typeEnum : ReInsuranceBillTypeEnum.values()) {
            if (code.equals(typeEnum.getCode())){
                return typeEnum.getName();
            }
        }
        return code;
    }
}
