package com.dtyunxi.tcbj.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.InspectionReleaseOperateLogReqDto;
import com.dtyunxi.tcbj.api.dto.request.InspectionReleaseOrderReqDto;
import com.dtyunxi.tcbj.api.dto.request.InspectionReleaseRecordReqDto;
import com.dtyunxi.tcbj.api.dto.request.InspectionResultOrderReqDto;
import com.dtyunxi.tcbj.api.dto.response.*;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;
import com.github.pagehelper.PageInfo;

import java.util.List;

/**
* 放行单服务接口
*
* @author 紫霄
* @since 2023-05-11
*/
@Api(tags = {"放行单服务"})
@FeignClient(
    contextId = "com-dtyunxi-tcbj-api-query-IInspectionReleaseOrderQueryApi",
    name = "${tcbj.center.report.api.name:tcbj-center-report}",
    path = "/v1/inspectionReleaseOrder",
    url = "${tcbj.center.report.api:}"
)
public interface IInspectionReleaseOrderQueryApi {

    /**
    * 根据id查询放行单
    *
    * @param id 放行单id
    * @return   放行单数据
    */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询放行单", notes = "根据id查询放行单")
    RestResponse<InspectionReleaseOrderRespDto> queryById(@PathVariable("id") Long id);

    /**
    * 放行单分页数据
    *
    * @param filter   放行单查询条件
    * @param pageNum  当前页
    * @param pageSize 页大小
    * @return 放行单分页数据
    */
    @GetMapping("/page")
    @ApiOperation(value = "放行单分页数据", notes = "根据filter查询条件查询放行单数据，filter=InspectionReleaseOrderReqDto")
    RestResponse<PageInfo<InspectionReleaseOrderRespDto>> queryByPage(@RequestParam("filter") String filter,
                                                           @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                           @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);


    @PostMapping("/queryPage")
    @ApiOperation(value = "放行记录分页数据", notes = "根据filter查询条件查询放行单数据，filter=InspectionReleaseOrderReqDto")
    RestResponse<PageInfo<InspectionReleaseRecordRespDto>> queryPage(@RequestBody InspectionReleaseRecordReqDto dto);

    @PostMapping("/queryPageCount")
    @ApiOperation(value = "放行记录状态统计", notes = "根据filter查询条件查询放行单数据，filter=InspectionReleaseOrderReqDto")
    RestResponse<InspectionReleaseCountRespDto> queryPageCount(@RequestBody InspectionReleaseRecordReqDto dto);

    @PostMapping("/queryHasReleaseTransferList/{longCode}/{batch}")
    @ApiOperation(value = "已放行调拨单明细列表", notes = "已放行调拨单明细列表")
    RestResponse<List<InspectionHasReleaseTransferRespDto>> queryHasReleaseTransferList(@PathVariable("longCode") String longCode, @PathVariable("batch") String batch);


    @PostMapping("/queryByLogPage")
    @ApiOperation(value = "放行操作日志分页数据", notes = "放行操作日志分页数据")
    RestResponse<PageInfo<InspectionReleaseOperateLogRespDto>> queryByLogPage(@RequestBody InspectionReleaseOperateLogReqDto dto);

    @PostMapping("/queryPreemptNotRelease/{longCode}/{batch}")
    @ApiOperation(value = "查询预占未放行数量", notes = "查询预占未放行数量")
    RestResponse<List<InspectionPreemptNotReleaseRespDto>> queryPreemptNotRelease(@PathVariable("longCode") String longCode, @PathVariable("batch") String batch);

    @PostMapping("/queryPreemptList/{longCode}/{batch}")
    @ApiOperation(value = "查询放行预占列表", notes = "查询放行预占列表")
    RestResponse<List<InspectionPreemptRespDto>> queryPreemptList(@PathVariable("longCode") String longCode, @PathVariable("batch") String batch);

    @PostMapping("/queryResultOrderList")
    @ApiOperation(value = "查询放行出入库结果单列表", notes = "查询放行预占列表")
    RestResponse<PageInfo<InspectionResultOrderRespDto>> queryResultOrderList(@RequestBody InspectionResultOrderReqDto reqDto);

    @PostMapping("/queryResultOrderListSum/{longCode}/{batch}")
    @ApiOperation(value = "查询放行出入库结果单数量汇总", notes = "查询放行出入库结果单数量汇总")
    RestResponse<InspectionResultOrderSumRespDto> queryResultOrderListSum(@PathVariable("longCode") String longCode, @PathVariable("batch") String batch);

    @PostMapping("/querySubBatch/{longCode}/{batch}")
    @ApiOperation(value = "查询批次子批次", notes = "查询批次子批次")
    RestResponse<List<String>> querySubBatch(@PathVariable("longCode") String longCode, @PathVariable("batch") String batch);

}
