package com.dtyunxi.tcbj.api;

import com.dtyunxi.rest.RestResponse;

import com.dtyunxi.tcbj.api.dto.request.RpAllotLoseEfficacyWarehouseReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;

import java.util.List;

/**
* 近效期仓库配置表服务接口
*
* @author jiejun
* @since 2022-10-14
*/
@Api(tags = {"近效期仓库配置表服务"})
@FeignClient(
        name = "${tcbj.center.report.api.name:tcbj-center-report}",
        path = "/v1/rpAllotLoseEfficacyWarehouse",
        url = "${tcbj.center.report.api:}"
)
public interface IRpAllotLoseEfficacyWarehouseApi {

/**
* 新增近效期仓库配置表
*
* @param addReqDto 近效期仓库配置表请求对象
* @return 处理结果
*/
    @PostMapping("/addRpAllotLoseEfficacyWarehouse")
    @ApiOperation(value = "新增近效期仓库配置表", notes = "新增近效期仓库配置表")
    RestResponse<Long> addRpAllotLoseEfficacyWarehouse(@RequestBody RpAllotLoseEfficacyWarehouseReqDto addReqDto);

    /**
     * 批量新增近效期仓库配置表
     * @param addReqDto 近效期仓库配置表请求对象
     * @return 处理结果
     */
    @PostMapping("/addBatchRpAllotLoseEfficacyWarehouse")
    @ApiOperation(value = "批量新增近效期仓库配置表", notes = "批量新增近效期仓库配置表")
    RestResponse<Void> addBatchRpAllotLoseEfficacyWarehouse(@RequestBody List<RpAllotLoseEfficacyWarehouseReqDto> addReqDto);

    /**
    * 修改近效期仓库配置表
    *
    * @param modifyReqDto 近效期仓库配置表请求对象
    * @return 处理结果
    */
    @PostMapping("/modifyRpAllotLoseEfficacyWarehouse")
    @ApiOperation(value = "修改近效期仓库配置表", notes = "修改近效期仓库配置表")
    RestResponse<Void> modifyRpAllotLoseEfficacyWarehouse(@RequestBody RpAllotLoseEfficacyWarehouseReqDto modifyReqDto);

    /**
    * 删除近效期仓库配置表
    *
    * @param ids        近效期仓库配置表删除数据ID
    * @param instanceId 实例ID
    * @return 处理结果
    */
    @DeleteMapping("/{ids}")
    @ApiOperation(value = "删除近效期仓库配置表", notes = "删除近效期仓库配置表")
    RestResponse<Void> removeRpAllotLoseEfficacyWarehouse(@PathVariable("ids") String ids,@RequestParam("instanceId") Long instanceId);
}
