package com.dtyunxi.tcbj.api.dto.request;

import java.util.Date;
import com.dtyunxi.dto.RequestDto;
import com.dtyunxi.tcbj.api.dto.BaseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

/**
* 逻辑仓库存查询请求dto
*
* @author wude
* @since 2022-03-07
*/
@Data
@ApiModel(value = "LogicInventoryReqDto", description = "逻辑仓库存查询请求dto")
public class LogicInventoryReqDto extends BaseDto {
    /**
    *  仓库编码
    */
    @ApiModelProperty(name = "warehouseCode", value = "仓库编码")
    private String warehouseCode;

    @ApiModelProperty(name = "warehouseCodeList", value = "仓库编码")
    private List<String> warehouseCodeList;
    /**
    *  仓库名称
    */
    @ApiModelProperty(name = "warehouseName", value = "仓库名称")
    private String warehouseName;
    /**
     *  仓库类型
     */
    @ApiModelProperty(name = "warehouseType", value = "仓库类型")
    private String warehouseType;
    /**
    *  商品长编码
    */
    @ApiModelProperty(name = "itemLongCode", value = "商品长编码")
    private String itemLongCode;
    /**
     *  商品名称
     */
    @ApiModelProperty(name = "itemName", value = "商品名称")
    private String itemName;

    /**
     *  商品名称前置
     */
    @ApiModelProperty(name = "itemNameStater", value = "商品名称前置")
    private String itemNameStater;
    /**
    *  批次
    */
    @ApiModelProperty(name = "batch", value = "批次")
    private String batch;
    /**
    *  批次类型 common-正常,defective-残次品,其他类型待定
    */
    @ApiModelProperty(name = "batchType", value = "批次类型 common-正常,defective-残次品,其他类型待定")
    private String batchType;
    /**
     *  实际库存大于0
     */
    @ApiModelProperty(name = "positiveBalance", value = "实际库存大于0 0否 1是")
    private Integer positiveBalance;
    @ApiModelProperty(name = "positiveAvailable", value = "实际可用大于0 0否 1是")
    private Integer positiveAvailable;
    /**
     *  是否过期
     */
    @ApiModelProperty(name = "expired", value = "是否过期 0否 1是")
    private Integer expired;

    /**
     *  过期开始时间
     */
    @ApiModelProperty(name = "expireBeginTime", value = "过期开始时间")
    private Date expireBeginTime;

    /**
     *  过期结束时间
     */
    @ApiModelProperty(name = "expireEndTime", value = "过期结束时间")
    private Date expireEndTime;
    /**
     *  仓库属性
     */
    @ApiModelProperty(name = "warehouseProperty", value = "仓库属性")
    private String warehouseProperty;

    /**
     *  仓库属性
     */
    @ApiModelProperty(name = "warehousePropertyCHN", value = "仓库属性(中文)")
    private String warehousePropertyCHN;
    @ApiModelProperty(name = "channelIds", value = "渠道编码")
    private List<Long> channelIds;
    /**
     *  所属物理仓
     */
    @ApiModelProperty(name = "physicsWarehouseId", value = "所属物理仓")
    private String physicsWarehouseId;
    /**
     *  仓库质量
     */
    @ApiModelProperty(name = "warehouseQuality", value = "仓库质量")
    private String warehouseQuality;
    /**
     *  所属物理仓
     */
    private String physicsWarehouseName;

    private String warehouseClassify;

    @ApiModelProperty(name = "subordinateLogicWarehouseId", value = "所属逻辑仓仓库ID")
    private Long subordinateLogicWarehouseId;

    @ApiModelProperty(name = "subordinateLogicWarehouseName", value = "所属逻辑仓名称")
    private String subordinateLogicWarehouseName;

    @ApiModelProperty(name = "organizationNames", value = "所属组织名称")
    private List<String> organizationNames;

    @ApiModelProperty(name = "organizationName", value = "所属组织名称")
    private String organizationName;

    @ApiModelProperty(name = "organizationCode", value = "组织code")
    private String organizationCode;


    @ApiModelProperty(name = "organizationId", value = "组织id")
    private Long organizationId;

    @ApiModelProperty(name = "balanceStart", value = "即时库存开始范围")
    private BigDecimal balanceStart;

    @ApiModelProperty(name = "balanceEnd", value = "即时库存结束范围")
    private BigDecimal balanceEnd;

    @ApiModelProperty(name = "preemptStart", value = "预占库存开始范围")
    private BigDecimal preemptStart;

    @ApiModelProperty(name = "preemptEnd", value = "预占库存结束范围")
    private BigDecimal preemptEnd;

    @ApiModelProperty(name = "availableStart", value = "可用库存开始范围")
    private BigDecimal availableStart;

    @ApiModelProperty(name = "availableEnd", value = "可用库存开始范围")
    private BigDecimal availableEnd;

    @ApiModelProperty(name = "nonZero", value = "无0")
    private Integer nonZero;

    @ApiModelProperty(name = "filterWarehouse", value = "过滤c仓库")
    private Integer filterWarehouse;

    @ApiModelProperty(name = "queryType", value = "默认逻辑仓, 1 逻辑仓 2 渠道仓 3 供货仓 4 物理仓")
    private Integer queryType = 1;

    @ApiModelProperty(name = "availableQueryType", value = "可用库存查询类型 1.自定义, 2,大于0 3,等于0, 4.小于0 5,大于等于0 6.小于等于0")
    private Integer availableQueryType;

    @ApiModelProperty(name = "preemptQueryType", value = "预占库存查询类型 1.自定义, 2,大于0 3,等于0, 4.小于0 5,大于等于0 6.小于等于0")
    private Integer preemptQueryType;

    @ApiModelProperty(name = "balanceQueryType", value = "即时库存查询类型 1.自定义, 2,大于0 3,等于0, 4.小于0 5,大于等于0 6.小于等于0")
    private Integer balanceQueryType;

    @ApiModelProperty(name = "开启近效期查询", value = "1 开启")
    private Integer enableEffectiveLoseQuery;
    @ApiModelProperty(name = "configId", value = "近效期配置id")
    private Long configId;

    @ApiModelProperty(name = "开启近效期库存过滤", value = "1 开启")
    private Integer enableEffectiveLoseWarehouse;

    @ApiModelProperty(name = "有效期是否小于9个月", value = "0否  1是")
    private Integer validityLessThanNineMonths;
}
