package com.dtyunxi.tcbj.api.dto.request;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

@Data
public class AllocationLogisticsQueryDto implements Serializable {

    @ApiModelProperty(
            name = "pageSize",
            required = true,
            value = "分页大小"
    )
    private Integer pageSize;

    @ApiModelProperty(
            name = "pageNum",
            required = true,
            value = "当前页码"
    )
    private Integer pageNum;
    @ApiModelProperty(
            name = "logisticsCompany",
            value = "物流公司"
    )
    private String logisticsCompany;
    @ApiModelProperty(
            name = "logisticsType",
            value = "承运方式"
    )
    private String logisticsType;
    @ApiModelProperty(
            name = "logisticsNo",
            value = "物流单号"
    )
    private String logisticsNo;
    @ApiModelProperty(
            name = "wmsNo",
            value = "WMS单号"
    )
    private String wmsNo;
    @ApiModelProperty(
            name = "businessType",
            value = "关联业务类型"
    )
    private String businessType;
    @ApiModelProperty(
            name = "businessOrderNo",
            value = "关联业务单号"
    )
    private String businessOrderNo;

    @ApiModelProperty(
            name = "status",
            value = "状态"
    )
    private String status;

    @ApiModelProperty(
            name = "createTimeStart",
            value = "创建时间开始"
    )
    private String createTimeStart;

    @ApiModelProperty(
            name = "createTimeEnd",
            value = "创建时间结束"
    )
    private String createTimeEnd;

    @ApiModelProperty(
            name = "overtimeFlag",
            value = "是否超时 0异常 1正常 2超时"
    )
    private String overtimeFlag;

    @ApiModelProperty(
            name = "stockFlag",
            value = "库存是否已供渠道仓  1是 0否"
    )
    private String stockFlag;

    @ApiModelProperty(name="longCode", value = "商品长编码")
    private String longCode;

    @ApiModelProperty(name="batch", value = "批次")
    private String batch;
}
