package com.dtyunxi.tcbj.api.dto.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * @author minyue
 * @description: 经销商报表-订单销售进度表入参
 * @since 2021-12-30 15:13
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "OrderSaleProgressReqDto", description = "订单销售进度表入参")
public class OrderSaleProgressReqDto extends ReportBaseReqDto {

    @ApiModelProperty(name = "placeTimeStart", value = "时间起(年月)")
    private String placeTimeStart;

    @ApiModelProperty(name = "placeTimeEnd", value = "时间(年月)")
    private String placeTimeEnd;

    @ApiModelProperty(name = "orderType", value = "订单类型(1:订单，2：售后单)")
    @NotNull
    private Integer orderType;

    @ApiModelProperty(name = "orderTradeStatus", value = "订单状态")
    private List<String> orderTradeStatus;
}
