package com.dtyunxi.tcbj.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.InspectionReleaseOperateLogReqDto;
import com.dtyunxi.tcbj.api.dto.response.InspectionReleaseOperateLogRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;
import com.github.pagehelper.PageInfo;

/**
* 放行操作日志服务接口
*
* @author 紫霄
* @since 2023-05-09
*/
@Api(tags = {"放行操作日志服务"})
@FeignClient(
    contextId = "com-dtyunxi-tcbj-api-query-IInspectionReleaseOperateLogQueryApi",
    name = "${tcbj.center.report.api.name:tcbj-center-report}",
    path = "/v1/InspectionReleaseOperateLog",
    url = "${tcbj.center.report.api:}"
)
public interface IInspectionReleaseOperateLogQueryApi {

    /**
    * 根据id查询放行操作日志
    *
    * @param id 放行操作日志id
    * @return   放行操作日志数据
    */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询放行操作日志", notes = "根据id查询放行操作日志")
    RestResponse<InspectionReleaseOperateLogRespDto> queryById(@PathVariable("id") Long id);


    @PostMapping("/queryByLogPage")
    @ApiOperation(value = "放行操作日志分页数据", notes = "根据filter查询条件查询放行操作日志数据，filter=InspectionReleaseOperateLogReqDto")
    RestResponse<PageInfo<InspectionReleaseOperateLogRespDto>> queryByPage(@RequestBody InspectionReleaseOperateLogReqDto dto);

}
