package com.dtyunxi.tcbj.api.query.es;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.OrganizationSplitReportReDto;
import com.dtyunxi.tcbj.api.dto.request.SaleIntransitEarlyWarningQueryReqDto;
import com.dtyunxi.tcbj.api.dto.request.SaleOrderReqDto;
import com.dtyunxi.tcbj.api.dto.request.SplitAnalysisReportReDto;
import com.dtyunxi.tcbj.api.dto.request.es.EsSaleReturnOrderListPageParams;
import com.dtyunxi.tcbj.api.dto.request.es.GetPlatformOrderListPageParams;
import com.dtyunxi.tcbj.api.dto.request.es.GetSaleOrderListPageEsParams;
import com.dtyunxi.tcbj.api.dto.request.es.SaleOrderContrastPageEsParams;
import com.dtyunxi.tcbj.api.dto.response.*;
import com.dtyunxi.tcbj.api.dto.response.es.*;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

@Api(tags = {"报表中心：交易中心查询（ES替代）"})
@FeignClient(
        name = "${tcbj.center.report.api.name:tcbj-center-report}",
        path = "/v1/trade/es",
        url = "${tcbj.center.report.api:}"
)
public interface TradeEsReportQueryApi {

    @ApiOperation(value = "渠道订单列表分页查询", notes = "渠道订单列表分页查询")
    @PostMapping(value = "/queryPlatformOrderListPage", produces = "application/json")
    RestResponse<PageInfo<PlatformOrderVO>> queryPlatformOrderListPage(@RequestBody GetPlatformOrderListPageParams pageParams);

    @ApiOperation(value = "内部销售订单分页查询", notes = "内部销售订单分页查询")
    @PostMapping(value = "/querySaleOrderListPage", produces = "application/json")
    RestResponse<PageInfo<SaleOrderRespEsVo>> querySaleOrderListPage(@RequestBody GetSaleOrderListPageEsParams pageEsParams);

    @ApiOperation(value = "内部销售退订单分页查询", notes = "内部销售退订单分页查询")
    @PostMapping(value = "/querySaleRefundOrderListPage", produces = "application/json")
    RestResponse<PageInfo<SaleRefundRespVo>> querySaleRefundOrderListPage(@RequestBody EsSaleReturnOrderListPageParams pageEsParams);

    @ApiOperation(value = "内部销售退订单统计", notes = "内部销售退订单统计")
    @PostMapping(value = "/querySaleRefundOrderCount", produces = "application/json")
    RestResponse<SaleReturnOrderCountVO> querySaleRefundOrderCount(@RequestBody EsSaleReturnOrderListPageParams pageEsParams);

    /**
     * 销售订单监控报表
     * @param pageEsParams
     * @return
     */
    @ApiOperation(value = "销售订单监控报表", notes = "销售订单监控报表")
    @PostMapping(value = "/querySaleOrderMonitorPage", produces = "application/json")
    RestResponse<PageInfo<SaleOrderRespEsVo>> querySaleOrderMonitorPage(@RequestBody GetSaleOrderListPageEsParams pageEsParams);

    @ApiOperation(value = "销售订单监控报表统计", notes = "销售订单监控报表统计")
    @PostMapping(value = "/querySaleOrderMonitorCount", produces = "application/json")
    RestResponse<SaleOrderCountRespDto> querySaleOrderMonitorCount(@RequestBody SaleOrderReqDto filter);

    /**
     * 订单明细报表-已出库tab页
     * @param pageEsParams
     * @return
     */
    @ApiOperation(value = "订单明细报表-已出库tab页", notes = "订单明细报表-已出库tab页")
    @PostMapping(value = "/queryOutSaleOrderDetail", produces = "application/json")
    RestResponse<PageInfo<SaleOrderItemRespEsVo>> queryOutSaleOrderDetail(@RequestBody SaleOrderContrastPageEsParams pageEsParams);

    @ApiOperation(value = "订单明细报表", notes = "订单明细报表")
    @PostMapping(value = "/querySaleOrderDetail", produces = "application/json")
    RestResponse<PageInfo<SaleOrderItemRespEsVo>> querySaleOrderDetail(@RequestBody SaleOrderContrastPageEsParams pageEsParams);


    @ApiOperation(value = "销售组织拆单报表", notes = "销售组织拆单报表")
    @PostMapping(value = "/queryOrganizationSplit", produces = "application/json")
    RestResponse<PageInfo<OrganizationSplitReportRespDto>> queryOrganizationSplit(@RequestBody OrganizationSplitReportReDto dto);

    @ApiOperation(value = "销售组织拆单报表统计接口", notes = "销售组织拆单报表统计接口")
    @PostMapping(value = "/queryOrganizationSplitCount", produces = "application/json")
    RestResponse<OrganizationSplitReportContRespDto> queryOrganizationSplitCount(@RequestBody OrganizationSplitReportReDto dto);

    @ApiOperation(value = "sku拆单报表", notes = "sku拆单报表")
    @PostMapping(value = "/querySkuSplit", produces = "application/json")
    RestResponse<PageInfo<SkuSplitReportRespDto>> querySkuSplit(@RequestBody OrganizationSplitReportReDto dto);

    @ApiOperation(value = "sku拆单报表统计接口", notes = "sku拆单报表统计接口")
    @PostMapping(value = "/querySkuSplitCount", produces = "application/json")
    RestResponse<SkuSplitReportContRespDto> querySkuSplitCount(@RequestBody OrganizationSplitReportReDto dto);

    @ApiOperation(value = "拆单分析报表", notes = "拆单分析报表")
    @PostMapping(value = "/querySplitAnalysis", produces = "application/json")
    RestResponse<List<SplitAnalysisReportRespDto>> querySplitAnalysis(@RequestBody SplitAnalysisReportReDto dto);

    @ApiOperation(value = "拆单分析报表统计接口", notes = "拆单分析报表统计接口")
    @PostMapping(value = "/querySplitAnalysisCount", produces = "application/json")
    RestResponse<OrganizationSplitReportContRespDto> querySplitAnalysisCount(@RequestBody SplitAnalysisReportReDto dto);


    /**
     * 销售在途预警报表
     * @param dto
     * @return
     */
    @ApiOperation(value = "销售在途预警报表", notes = "销售在途预警报表")
    @PostMapping(value = "/querySaleIntransitEarlyWarning", produces = "application/json")
    RestResponse<PageInfo<SaleIntransitEarlyWarningReportRespDto>> querySaleIntransitEarlyWarning(@RequestBody SaleIntransitEarlyWarningQueryReqDto dto);
    /**
     * 销售在途预警报表状态统计
     * @param dto
     * @return
     */
    @ApiOperation(value = "销售在途预警报表状态统计", notes = "销售在途预警报表状态统计")
    @PostMapping(value = "/querySaleIntransitEarlyWarningCount", produces = "application/json")
    RestResponse<SaleIntransitEarlyWarningCountRespDto> querySaleIntransitEarlyWarningCount(@RequestBody SaleIntransitEarlyWarningQueryReqDto dto);
}
