package com.dtyunxi.tcbj.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.StorageChargeBillReqDto;
import com.dtyunxi.tcbj.api.dto.response.StorageBillCountRespDto;
import com.dtyunxi.tcbj.api.dto.response.StorageChargeBillPrintDto;
import com.dtyunxi.tcbj.api.dto.response.StorageChargeBillRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
* 仓储账单表服务接口
*
* @author by_liusong
* @since 2022-07-15
*/
@Api(tags = {"仓储账单表服务"})
@FeignClient(
    contextId = "com-dtyunxi-tcbj-api-query-IStorageChargeBillQueryApi",
    name = "${tcbj.center.report.api.name:tcbj-center-report}",
    path = "/v1/storageChargeBill",
    url = "${tcbj.center.report.api:}"
)
public interface IStorageChargeBillQueryApi {

    /**
    * 根据id查询仓储账单表
    *
    * @param id 仓储账单表id
    * @return   仓储账单表数据
    */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询仓储账单表", notes = "根据id查询仓储账单表")
    RestResponse<StorageChargeBillRespDto> queryById(@PathVariable("id") Long id);

    /**
    * 仓储账单表分页数据
    *
    * @param filter   仓储账单表查询条件
    * @param pageNum  当前页
    * @param pageSize 页大小
    * @return 仓储账单表分页数据
    */
    @GetMapping("/page")
    @ApiOperation(value = "仓储账单表分页数据", notes = "根据filter查询条件查询仓储账单表数据，filter=StorageChargeBillReqDto")
    RestResponse<PageInfo<StorageChargeBillRespDto>> queryByPage(@RequestParam("filter") String filter,
                                                           @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                           @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);

    @PostMapping("/queryByPageCount")
    @ApiOperation(value = "仓储账单统计数据", notes = "仓储账单统计数据")
    RestResponse<StorageBillCountRespDto> queryByPageCount(@RequestBody StorageChargeBillReqDto storageChargeBillReqDto);

    /**
     * 获取仓储打印信息
     * @return
     */
    @GetMapping("/printBill")
    @ApiOperation(value = "获取仓储打印信息", notes = "获取仓储打印信息，filter=StorageChargeBillReqDto")
    RestResponse<List<StorageChargeBillPrintDto>> printBill(@RequestParam("filter") String filter);

}
