package com.dtyunxi.tcbj.api.dto.response;

import java.util.Date;

import com.dtyunxi.dto.RequestDto;
import com.dtyunxi.tcbj.api.dto.BaseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import java.math.BigDecimal;

/**
 * 质检转合格返回对象
 *
 * @author tangjiaye
 * @since 2022-04-20
 */
@Data
@ApiModel(value = "QualityInfoDetailReqDto", description = "质检转合格返回对象")
public class QualityInfoDetailReqDto extends BaseDto {
    /**
     * 主键id
     */
    @ApiModelProperty(name = "id", value = "主键id")
    private Long id;
    /**
     * 计划单号
     */
    @ApiModelProperty(name = "plannedOrderNo", value = "计划单号")
    private String plannedOrderNo;
    /**
     * 平台单号(来源于第三方系统)
     */
    @ApiModelProperty(name = "platformOrderNo", value = "平台单号(来源于第三方系统)")
    private String platformOrderNo;
    /**
     * 单据类型:purchase-采购订单,outsource-委外订单,production-生产订单
     */
    @ApiModelProperty(name = "orderType", value = "单据类型:purchase-采购订单,outsource-委外订单,production-生产订单")
    private String orderType;
    /**
     * 业务类型:purchase-采购促销订单,outsource-委外订单,production-生产订单
     */
    @ApiModelProperty(name = "businessType", value = "业务类型:purchase-采购促销订单,outsource-委外订单,production-生产订单")
    private String businessType;
    /**
     * 收货仓库ID
     */
    @ApiModelProperty(name = "warehouseId", value = "收货仓库ID")
    private Long warehouseId;
    /**
     * 收货仓库编码
     */
    @ApiModelProperty(name = "warehouseCode", value = "收货仓库编码")
    private String warehouseCode;
    /**
     * 收货仓库编码
     */
    @ApiModelProperty(name = "inWarehouseCode", value = "收货仓库编码")
    private String inWarehouseCode;
    /**
     * 收货仓库名称
     */
    @ApiModelProperty(name = "warehouseName", value = "收货仓库名称")
    private String warehouseName;
    /**
     * 货品ID
     */
    @ApiModelProperty(name = "cargoId", value = "货品ID")
    private Long cargoId;
    /**
     * 商品长编码
     */
    @ApiModelProperty(name = "longCode", value = "商品长编码")
    private String longCode;
    /**
     * 货品编码
     */
    @ApiModelProperty(name = "cargoCode", value = "货品编码")
    private String cargoCode;
    /**
     * 货品名称
     */
    @ApiModelProperty(name = "cargoName", value = "货品名称")
    private String cargoName;
    /**
     * 货品货号
     */
    @ApiModelProperty(name = "artNo", value = "货品货号")
    private String artNo;
    /**
     * 批次
     */
    @ApiModelProperty(name = "batch", value = "批次")
    private String batch;
    /**
     * 过期日期
     */
    @ApiModelProperty(name = "expireTime", value = "过期日期")
    private Date expireTime;
    /**
     * 生产日期
     */
    @ApiModelProperty(name = "produceTime", value = "生产日期")
    private Date produceTime;
    /**
     * 商品数量
     */
    @ApiModelProperty(name = "quantity", value = "商品数量")
    private BigDecimal quantity;

    @ApiModelProperty(name = "reportTime", value = "接收报告时间")
    private String reportTime;
    /**
     * 质检报告,qualified-合格,disqualification-不合格
     */
    @ApiModelProperty(name = "reportResult", value = "质检报告,qualified-合格,disqualification-不合格")
    private String reportResult;
    /**
     * 推送WMS状态,success-成功,failure-失败
     */
    @ApiModelProperty(name = "pushWmsStatus", value = "推送WMS状态,success-成功,failure-失败")
    private String pushWmsStatus;

    /**
     * 推送WMS状态,1-成功,0-失败
     */

    @ApiModelProperty(name = "wmsStatus", value = "推送WMS状态,success-成功,failure-失败")
    private String wmsStatus;
    /**
     * 放行状态：unPassed-否(待放行),passed-是(已放行)
     */
    @ApiModelProperty(name = "dischargedStatus", value = "放行状态：unPassed-否(待放行),passed-是(已放行)")
    private String dischargedStatus;
    /**
     * 超7天未放行,unPassed-是(未放行),passed-否(已放行)
     */
    @ApiModelProperty(name = "dischargedFlag", value = "超7天未放行,unPassed-是(未放行),passed-否(已放行)")
    private Integer dischargedFlag;

    /**
     * 超7天未出报告,
     */
    @ApiModelProperty(name = "dischargedReport", value = "超7天未出报告,1-是,0-否")
    private Integer dischargedReport;


    /**
     * 是否批次倒挂,upside-是(批次倒挂),common-否(正常)
     */
    @ApiModelProperty(name = "batchUpsideFlag", value = "是否批次倒挂,upside-是(批次倒挂),common-否(正常)")
    private Integer batchUpsideFlag;
    /**
     * 备注
     */
    @ApiModelProperty(name = "remark", value = "备注")
    private String remark;
    /**
     * 备注字体颜色
     */
    @ApiModelProperty(name = "remarkColour", value = "备注字体颜色")
    private String remarkColour;
    /**
     * 出库数量
     */
    @ApiModelProperty(name = "doneQuantity", value = "出库数量")
    private BigDecimal doneQuantity;
    /**
     * 质检报告URL
     */
    @ApiModelProperty(name = "reportResultUrl", value = "质检报告URL")
    private String reportResultUrl;


    @ApiModelProperty(name = "specification")
    private String specification;

    @ApiModelProperty(name = "updatePerson")
    private String updatePerson;

    @ApiModelProperty(name = "updateTime")
    private Date updateTime;

    /**
     * 放行数量
     */
    @ApiModelProperty(name = "releaseNum")
    private BigDecimal releaseNum;

    /**
     * 出库数量
     */
    @ApiModelProperty(name = "outNum")
    private BigDecimal outNum;

    private Date createTime;

    /**
     * 预占数
     */
    private BigDecimal preempt;


}