package com.dtyunxi.tcbj.api.dto.response;

import com.dtyunxi.dto.ResponseDto;
import com.dtyunxi.util.DateUtil;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import java.math.BigDecimal;
import java.util.Date;

/**
* 逻辑仓库存响应dto
*
* @author wude
* @since 2022-03-07
*/
@Getter
@Setter
@ApiModel(value = "LogicInventoryRespDto", description = "逻辑仓库存响应dto")
public class LogicInventoryRespDto extends ResponseDto{
    /**
    *  主键id
    */
    @ApiModelProperty(name = "id", value = "主键id")
    private Long id;
    /**
    *  仓库ID
    */
    @ApiModelProperty(name = "warehouseId", value = "仓库ID")
    private Long warehouseId;

    @ApiModelProperty(name = "organizationId", value = "组织id")
    private Long organizationId;
    /**
    *  仓库编码
    */
    @ApiModelProperty(name = "warehouseCode", value = "仓库编码")
    private String warehouseCode;
    /**
    *  仓库名称
    */
    @ApiModelProperty(name = "warehouseName", value = "仓库名称")
    private String warehouseName;
    /**
     *  仓库类型
     */
    @ApiModelProperty(name = "warehouseType", value = "仓库类型")
    private String warehouseType;
    /**
    *  批次
    */
    @ApiModelProperty(name = "batch", value = "批次")
    private String batch;
    /**
    *  批次类型 common-正常,defective-残次品,其他类型待定
    */
    @ApiModelProperty(name = "batchType", value = "批次类型 common-正常,defective-残次品,其他类型待定")
    private String batchType;
    /**
    *  总库存
    */
    @ApiModelProperty(name = "balance", value = "总库存")
    private BigDecimal balance;
    /**
    *  预占库存
    */
    @ApiModelProperty(name = "preempt", value = "预占库存")
    private BigDecimal preempt;
    /**
    *  已分配库存
    */
    @ApiModelProperty(name = "allocate", value = "已分配库存")
    private BigDecimal allocate;
    /**
    *  活动分配库存
    */
    @ApiModelProperty(name = "activityAllocate", value = "活动分配库存")
    private BigDecimal activityAllocate;
    /**
    *  在途库存
    */
    @ApiModelProperty(name = "intransit", value = "在途库存")
    private BigDecimal intransit;
    /**
    *  已调拨库存
    */
    @ApiModelProperty(name = "transfer", value = "已调拨库存")
    private BigDecimal transfer;
    /**
    *  已完成库存
    */
    @ApiModelProperty(name = "completed", value = "已完成库存")
    private BigDecimal completed;
    /**
    *  可用库存,可用库存 = 总库存 + 在途库存 - 已完成库存 - 预占库存 - 已分配库存 - 已调拨库存 - 活动分配库存
    */
    @ApiModelProperty(name = "available", value = "可用库存,可用库存 = 总库存 + 在途库存 - 已完成库存 - 预占库存 - 已分配库存 - 已调拨库存 - 活动分配库存")
    private BigDecimal available;
    /**
     *  待收库存
     */
    @ApiModelProperty(name = "futureIn", value = "待收库存")
    private BigDecimal futureIn;
    /**
    *  备注
    */
    @ApiModelProperty(name = "remark", value = "备注")
    private String remark;
    /**
    *  过期日期
    */
    @ApiModelProperty(name = "expireTime", value = "过期日期")
    private Date expireTime;
    /**
    *  生产日期
    */
    @ApiModelProperty(name = "produceTime", value = "生产日期")
    private Date produceTime;
    /**
     *  商品长编码
     */
    @ApiModelProperty(name = "itemLongCode", value = "商品长编码")
    private String itemLongCode;

    @ApiModelProperty(name = "longCode", value = "商品长编码")
    private String longCode;
    /**
     *  商品条码
     */
    @ApiModelProperty(name = "itemBarCode", value = "商品条码")
    private String itemBarCode;
    /**
     *  商品名称
     */
    @ApiModelProperty(name = "itemName", value = "商品名称")
    private String itemName;
    /**
     *  仓库属性
     */
    @ApiModelProperty(name = "warehouseProperty", value = "仓库属性")
    private String warehouseProperty;
    /**
     *  所属物理仓
     */
    @ApiModelProperty(name = "physicsWarehouseName", value = "所属物理仓")
    private String physicsWarehouseName;

    private String physicsWarehouseCode;
    /**
     *  仓库质量
     */
    @ApiModelProperty(name = "warehouseQuality", value = "仓库质量")
    private String warehouseQuality;
    /**
     *  是否过期
     */
    @ApiModelProperty(name = "expired", value = "是否过期 0否 1是")
    private Integer expired;

    @ApiModelProperty(name = "expiration", value = "效期预警")
    private Integer expiration;


    /**
     * 转合格入库仓
     */
    @ApiModelProperty(name = "inQualifyWarehouse", value = "转合格入库仓")
    private String inQualifyWarehouse;

    /**
     * 近效期调入仓
     */
    @ApiModelProperty(name = "inNearExpireWarehouse", value = "近效期调入仓")
    private String inNearExpireWarehouse;


    private BigDecimal lockInventory;

    //-- 总表库存查询多的参数
    @ApiModelProperty(name = "organizationCode", value = "组织code")
    private String organizationCode;

    @ApiModelProperty(name = "organizationName", value = "所属组织名称")
    private String organizationName;

    @ApiModelProperty(name = "specification", value = "规格")
    private String specification;

    @ApiModelProperty(name = "unitId", value = "单位")
    private String unitId;

    @ApiModelProperty(name = "createTime", value = "库存创建时间")
    private Date createTime;

    @ApiModelProperty(name = "subordinateLogicWarehouseId", value = "所属逻辑仓仓库ID")
    private Long subordinateLogicWarehouseId;

    @ApiModelProperty(name = "subordinateLogicWarehouseName", value = "所属逻辑仓名称")
    private String subordinateLogicWarehouseName;

    @ApiModelProperty(name = "skuCode", value = "")
    private String skuCode;

    @ApiModelProperty(name = "skuName", value = "")
    private String skuName;



}
