package com.dtyunxi.tcbj.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.ExpressCostReportPollNumDto;
import com.dtyunxi.tcbj.api.dto.ExpressCostReportQueryDto;
import com.dtyunxi.tcbj.api.dto.request.ExpressCostDetailReqDto;
import com.dtyunxi.tcbj.api.dto.response.ExpressCostDetailRespDto;
import com.dtyunxi.tcbj.api.dto.response.ReInsuranceBillCountDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.math.BigDecimal;
import java.util.List;

/**
* 快递费用计费配置服务接口
* @author jiejun
*/
@Api(tags = {"快递费用计费配置服务"})
@FeignClient(
    contextId = "com-dtyunxi-tcbj-api-query-IExpressCostConfigQueryApi",
    name = "${tcbj.center.report.api.name:tcbj-center-report}",
    path = "/v1/expressCostConfig",
    url = "${tcbj.center.report.api:}"
)
public interface IExpressCostConfigQueryApi {


    @GetMapping("/queryDifferenceValue")
    @ApiOperation(value = "根据id查询快递费用报表详情", notes = "根据id查询快递费用报表详情")
    RestResponse<BigDecimal> queryDifferenceValue();

}
