package com.dtyunxi.tcbj.api.dto.request;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;
import java.util.List;

@Data
public class SaleReturnDetailReqDto {

    @ApiModelProperty(name = "createTimeStart", value = "入库时间开始")
    @JsonProperty("createTimeStart")
    private Date createTimeStart;

    @ApiModelProperty(name = "createTimeEnd", value = "入库时间结束")
    @JsonProperty("createTimeEnd")
    private Date createTimeEnd;

    @ApiModelProperty(name = "organizationIds", value = "销售组织ID集合")
    @JsonProperty("organizationIds")
    private List<Long> organizationIds;

    @ApiModelProperty(name = "refundStatusList", value = "退货状态集合")
    @JsonProperty("refundStatusList")
    private List<String> refundStatusList;

    @ApiModelProperty(name="pageNum", value = "页码")
    @JsonProperty("pageNum")
    private Integer pageNum = 1;

    @ApiModelProperty(name="pageSize", value = "每页数量")
    @JsonProperty("pageSize")
    private Integer pageSize = 10;
}


