package com.dtyunxi.tcbj.api.dto;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import java.util.List;

/**
 * @Description SortingExpenseDetailPageReqDto-分拣费用明细报表分页查询对象
 * @Author 代码生成器
 * @Date 2025-08-26 14:59:24
 * @TemplateVersion 1.0.0
 * @MD5Code d508056960dd907183e49daa666f2e51
 **/
@Setter
@Getter
@NoArgsConstructor
@AllArgsConstructor
@ApiModel(value = "SortingExpenseChargingReportPageReqDto", description = "分拣计费明细报表分页查询对象")
public class SortingExpenseChargingReportPageReqDto extends SortingExpenseChargingPageReqDto {

    @ApiModelProperty(name = "bookkeepingMonth", value = "记账月份")
    private String bookkeepingMonth;

    @ApiModelProperty(name = "bookkeepingMonthStartTime", value = "记账月份格式化开始时间")
    private String bookkeepingMonthStartTime;

    @ApiModelProperty(name = "bookkeepingMonthEndTime", value = "记账月份格式化结束时间")
    private String bookkeepingMonthEndTime;

    @ApiModelProperty(name = "outWarehouseStartTime", value = "出库日期开始日期")
    @JsonProperty("outWarehouseStartTime")
    private String outWarehouseStartTime;


    @ApiModelProperty(name = "outWarehouseEndTime", value = "出库日期结束日期")
    @JsonProperty("outWarehouseEndTime")
    private String outWarehouseEndTime;


    @ApiModelProperty(name = "wmsDocumentNo", value = "WMS出库单号")
    @JsonProperty("wmsDocumentNo")
    private String wmsDocumentNo;


    @ApiModelProperty(name = "documentNo", value = "出库结果单号")
    @JsonProperty("documentNo")
    private String documentNo;


    @ApiModelProperty(name = "businessType", value = "业务类型")
    @JsonProperty("businessType")
    private String businessType;


    @ApiModelProperty(name = "outWarehouseCode", value = "调出仓")
    @JsonProperty("outWarehouseCode")
    private String outWarehouseCode;


    @ApiModelProperty(name = "costAttributionCode", value = "费用归属")
    @JsonProperty("costAttributionCode")
    private String costAttributionCode;


    @ApiModelProperty(name = "goodsLongCode", value = "商品长编码")
    @JsonProperty("goodsLongCode")
    private String goodsLongCode;


    @ApiModelProperty(name = "goodsName", value = "商品名称")
    @JsonProperty("goodsName")
    private String goodsName;


    @ApiModelProperty(name = "outOrgName", value = "调出库存组织")
    @JsonProperty("outOrgName")
    private String outOrgName;


    @ApiModelProperty(name = "inWarehouseCode", value = "调入仓")
    @JsonProperty("inWarehouseCode")
    private String inWarehouseCode;


    @ApiModelProperty(name = "inOrgName", value = "调入库存组织")
    @JsonProperty("inOrgName")
    private String inOrgName;

    @ApiModelProperty(name = "isAbnormal", value = "是否异常")
    @JsonProperty("isAbnormal")
    private String isAbnormal;

    @ApiModelProperty(name = "outOrgNameCode", value = "调出库组织")
    @JsonProperty("outOrgNameCode")
    private String outOrgNameCode;

    @ApiModelProperty(name = "inOrgNameCode", value = "调入库存组织编码")
    @JsonProperty("inOrgNameCode")
    private String inOrgNameCode;

    @ApiModelProperty(name = "outPhysicsWarehouseNameList", value = "调出物理仓名称集合")
    private List<String> outPhysicsWarehouseNameList;

    @ApiModelProperty(name = "outPhysicsWarehouseCodeList", value = "调出物理仓编码集合")
    private List<String> outPhysicsWarehouseCodeList;

    @ApiModelProperty(name = "transportStyleList", value = "承运方式名称集合")
    private List<String> transportStyleList;

    @ApiModelProperty(name = "customerNameList", value = "客户名称集合")
    private List<String> customerNameList;

    @ApiModelProperty(name = "endProvinceCode", value = "目的省")
    @JsonProperty("endProvinceCode")
    private String endProvinceCode;

    @ApiModelProperty(name = "endCityCode", value = "目的市")
    @JsonProperty("endCityCode")
    private String endCityCode;

    @ApiModelProperty(name = "outDocumentNoList", value = "出库通知单集合")
    private List<String> outDocumentNoList;

    @ApiModelProperty(name = "costTypeList", value = "计费类型集合")
    private List<String> costTypeList;

    @ApiModelProperty(name = "billingOrgList", value = "计费组织集合")
    private List<String> billingOrgList;

    @ApiModelProperty(name = "billingFeeFlag", value = "是否计费,0不计费,1计费")
    private Integer billingFeeFlag;

    @ApiModelProperty(name = "maxId", value = "排序最大Id")
    private Long maxId;

    @ApiModelProperty(name = "shipmentEnterpriseCodeList", value = "物流公司编码集合")
    private List<String> shipmentEnterpriseCodeList;

}