package com.dtyunxi.tcbj.api.dto.request;

import com.dtyunxi.tcbj.api.dto.entity.BasePageDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;
import java.util.List;

@ApiModel(value = "DeliveryTimeLimitRespDto", description = "仓库发货时效统计")
@Data
public class DeliveryTimeLimitReqDto extends BasePageDto {
    @ApiModelProperty(name = "statisticalTime", value = "统计时间")
    private String statisticalTime;

    @ApiModelProperty(name = "placeTimeStart", value = "统计时间开始")
    private String statisticalTimeStart;

    @ApiModelProperty(name = "placeTimeEnd", value = "统计时间结束")
    private String statisticalTimeEnd;

    @ApiModelProperty(name = "outPhysicsWarehouseName", value = "物理仓")
    private String outPhysicsWarehouseName;

    @ApiModelProperty(name = "outPhysicsWarehouseNameList", value = "物理仓")
    private List<String> outPhysicsWarehouseNameList;

    @ApiModelProperty(name = "inPhysicsWarehouseNameList", value = "入库物理仓")
    private List<String> inPhysicsWarehouseNameList;

    @ApiModelProperty(name = "businessType", value = "业务类型")
    private String businessType;

    @ApiModelProperty(name = "relevanceNo", value = "关联业务单号")
    private String relevanceNo;

    @ApiModelProperty(name = "documentNo", value = "出库通知单单号")
    private String documentNo;

    @ApiModelProperty(name = "documentResultNo", value = "出库结果单单号")
    private String documentResultNo;

    @ApiModelProperty(name = "statisticalTime", value = "推送给仓库时间")
    private String pushTime;

    @ApiModelProperty(name = "placeTimeStart", value = "推送给仓库时间开始")
    private String pushTimeStart;

    @ApiModelProperty(name = "placeTimeEnd", value = "推送给仓库时间结束")
    private String pushTimeEnd;

    @ApiModelProperty(name = "statisticalTime", value = "仓库发货返回时间")
    private String warehouseTime;

    @ApiModelProperty(name = "placeTimeStart", value = "仓库发货返回时间开始")
    private String warehouseTimeStart;

    @ApiModelProperty(name = "placeTimeEnd", value = "仓库发货返回时间结束")
    private String warehouseTimeEnd;

    @ApiModelProperty(name = "statisticalTime", value = "发货时效(天)")
    private String deliveryTime;

    @ApiModelProperty(name = "businessTypeList", value = "业务类型")
    private List<String> businessTypeList;


}
