package com.dtyunxi.tcbj.api.dto.request;

import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;
import java.util.List;

@Data
@ApiModel(value = "ReInsurancePremiumExceptionDto", description = "保费明细更新异常数据对象")
public class ReInsurancePremiumExceptionDto extends RequestDto {
    /*
     * 开始时间
     */
    @ApiModelProperty(name = "beginDate",value = "开始时间")
    private Date beginDate;

    /*
     * 结束时间
     */
    @ApiModelProperty(name = "endDate",value = "结束时间")
    private Date endDate;

    /*
     * 出库通知单
     */
    @ApiModelProperty(name = "outDocumentNo",value = "出库通知单")
    private String outDocumentNo;

    /*
     * 物流公司
     */
    @ApiModelProperty(name = "shippingCompanyCode",value = "物流公司")
    private List<String> shippingCompanyCode;

    /*
     * 承运方式
     */
    @ApiModelProperty(name = "shippingType",value = "承运方式")
    private List<String> shippingType;

    /*
     * 保险公司
     */
    @ApiModelProperty(name = "insuranceCompany",value = "保险公司")
    private List<String> insuranceCompany;
}
