package com.dtyunxi.tcbj.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.response.PCPCustomerLevelRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.GetMapping;
import com.github.pagehelper.PageInfo;

/**
* 客户级别服务接口
*
* @author yuangui
* @since 2022-03-19
*/
@Api(tags = {"客户中心:PCP客户级别服务"})
@FeignClient(
    contextId = "com-dtyunxi-tcbj-api-query-ICustomerLevelQueryApi",
    name = "${tcbj.center.report.api.name:tcbj-center-report}",
    path = "/v2/customer-level",
    url = "${tcbj.center.report.api:}"
)
public interface IPCPCustomerLevelQueryApi {

    /**
    * 根据id查询客户级别
    *
    * @param id 客户级别id
    * @return   客户级别数据
    */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询客户级别", notes = "根据id查询客户级别")
    RestResponse<PCPCustomerLevelRespDto> queryById(@PathVariable("id") Long id);

    /**
    * 客户级别分页数据
    *
    * @param filter   客户级别查询条件
    * @param pageNum  当前页
    * @param pageSize 页大小
    * @return 客户级别分页数据
    */
    @GetMapping("/page")
    @ApiOperation(value = "客户级别分页数据", notes = "根据filter查询条件查询客户级别数据，filter=CustomerLevelReqDto")
    RestResponse<PageInfo<PCPCustomerLevelRespDto>> queryByPage(@RequestParam("filter") String filter,
                                                           @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                           @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);

}
