package com.dtyunxi.tcbj.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.StorageChargeApportionBasicsReqDto;
import com.dtyunxi.tcbj.api.dto.response.StorageChargeApportionBasicsRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.GetMapping;
import com.github.pagehelper.PageInfo;

/**
* 仓储费用分摊记录表服务接口
*
* @author by_liusong
* @since 2022-08-26
*/
@Api(tags = {"仓储费用分摊记录表服务"})
@FeignClient(
    contextId = "com-dtyunxi-tcbj-api-query-IStorageChargeApportionBasicsQueryApi",
    name = "yundt-cube-center-report",
    path = "/v1/storage",
    url = "${yundt.cube.center.report.api:}"
)
public interface IStorageChargeApportionBasicsQueryApi {

    /**
    * 根据id查询仓储费用分摊记录表
    *
    * @param id 仓储费用分摊记录表id
    * @return   仓储费用分摊记录表数据
    */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询仓储费用分摊记录表", notes = "根据id查询仓储费用分摊记录表")
    RestResponse<StorageChargeApportionBasicsRespDto> queryById(@PathVariable("id") Long id);

    /**
    * 仓储费用分摊记录表分页数据
    *
    * @param filter   仓储费用分摊记录表查询条件
    * @param pageNum  当前页
    * @param pageSize 页大小
    * @return 仓储费用分摊记录表分页数据
    */
    @GetMapping("/page")
    @ApiOperation(value = "仓储费用分摊记录表分页数据", notes = "根据filter查询条件查询仓储费用分摊记录表数据，filter=StorageChargeApportionBasicsReqDto")
    RestResponse<PageInfo<StorageChargeApportionBasicsRespDto>> queryByPage(@RequestParam("filter") String filter,
                                                           @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                           @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);

}
