package com.dtyunxi.tcbj.api.dto.response;

import java.util.Date;

import com.alibaba.fastjson.annotation.JSONField;
import com.dtyunxi.dto.ResponseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import com.dtyunxi.dto.BaseRespDto;

import javax.persistence.Column;

/**
* 仓储账单明细表Eo对象
*
* @author by_liusong
* @since 2022-07-15
*/
@ApiModel(value = "StorageChargeDetailRespDto", description = "仓储账单明细表Eo对象")
public class StorageChargeDetailRespDto extends BaseRespDto{
    /**
    *  
    */
    @ApiModelProperty(name = "id", value = "")
    private Long id;
    /**
    *  存储日期
    */
    @ApiModelProperty(name = "storageTime", value = "存储日期")
    @JSONField(format ="yyyy-MM-dd")
    private Date storageTime;
    /**
     *  记账月份
     */
    @ApiModelProperty(name = "billTime", value = "记账月份")
    private String billTime;
    /**
    *  仓库编码
    */
    @ApiModelProperty(name = "warehouseCode", value = "仓库编码")
    private String warehouseCode;
    /**
    *  仓库名称
    */
    @ApiModelProperty(name = "warehouseName", value = "仓库名称")
    private String warehouseName;
    /**
    *  商品长码
    */
    @ApiModelProperty(name = "opLongCode", value = "商品长码")
    private String opLongCode;
    /**
    *  商品名称
    */
    @ApiModelProperty(name = "itemName", value = "商品名称")
    private String itemName;
    /**
    *  批次
    */
    @ApiModelProperty(name = "batch", value = "批次")
    private String batch;
    /**
    *  逻辑仓编码
    */
    @ApiModelProperty(name = "logicWarehouseCode", value = "逻辑仓编码")
    private String logicWarehouseCode;
    /**
    *  逻辑仓名称
    */
    @ApiModelProperty(name = "logicWarehouseName", value = "逻辑仓名称")
    private String logicWarehouseName;
    /**
     *  计费组织id
     */
    @ApiModelProperty(name = "chargeOrgId", value = "计费组织id")
    private Long chargeOrgId;
    /**
     *  计费组织名称
     */
    @ApiModelProperty(name = "chargeOrgName", value = "计费组织名称")
    private String chargeOrgName;
    /**
     *  计费组织编码
     */
    @ApiModelProperty(name = "chargeOrgCode", value = "计费组织编码")
    private String chargeOrgCode;

    /**
     *  库存组织id
     */
    @ApiModelProperty(name = "belongOrgId", value = "库存组织id")
    private Long belongOrgId;
    /**
     *  库存组织名称
     */
    @ApiModelProperty(name = "belongOrgName", value = "库存组织名称")
    private String belongOrgName;
    /**
    *  期初库存
    */
    @ApiModelProperty(name = "initialInventoryNum", value = "期初库存")
    private Integer initialInventoryNum;
    /**
    *  入库数量
    */
    @ApiModelProperty(name = "inDeliveryNum", value = "入库数量")
    private Integer inDeliveryNum;
    /**
    *  出库数量
    */
    @ApiModelProperty(name = "outDeliveryNum", value = "出库数量")
    private Integer outDeliveryNum;
    /**
    *  期末库存
    */
    @ApiModelProperty(name = "endInventoryNum", value = "期末库存")
    private Integer endInventoryNum;
    /**
    *  调整类型；0：减少 1：增加
    */
    @ApiModelProperty(name = "adjustType", value = "调整类型；0：减少 1：增加")
    private Integer adjustType;
    /**
    *  调整库存数
    */
    @ApiModelProperty(name = "adjustDeliveryNum", value = "调整库存数")
    private Integer adjustDeliveryNum;
    /**
    *  备注
    */
    @ApiModelProperty(name = "remark", value = "备注")
    private String remark;
    /**
    *  码托数
    */
    @ApiModelProperty(name = "zhTrayNum", value = "码托数")
    private Integer zhTrayNum;
    /**
    *  装箱数
    */
    @ApiModelProperty(name = "packingQuantity", value = "装箱数")
    private Integer packingQuantity;
    /**
    *  出库总体积
    */
    @ApiModelProperty(name = "allOutVolume", value = "出库总体积")
    private BigDecimal allOutVolume;
    /**
    *  当日总板数
    */
    @ApiModelProperty(name = "allDaySupport", value = "当日总板数")
    private Integer allDaySupport;
    /**
    *  组织所占板数
    */
    @ApiModelProperty(name = "organizationSupport", value = "组织所占板数")
    private BigDecimal organizationSupport;
    /**
     *  业务类型;0:常规计费;1:内部交易;2:人工分摊;
     */
    @ApiModelProperty(name = "bizType", value = "业务类型;0:常规计费;1:内部交易;2:人工分摊;")
    private Integer bizType;

    /**
     *  账单异常信息
     */
    @ApiModelProperty(name = "exceptionInfo", value = "账单异常信息")
    private String exceptionInfo;

    /**
    *  组织id
    */
    @ApiModelProperty(name = "orgId", value = "组织id")
    private Long orgId;

    /**
     *  是否已归档,0未归档,1已归档
     */
    @ApiModelProperty(name = "placedFlag", value = "是否已归档,0未归档,1已归档")
    private Integer placedFlag;

    public void setId(Long id){
    this.id = id;
    }
    public Long getId(){
    return this.id;
    }
    public void setStorageTime(Date storageTime){
    this.storageTime = storageTime;
    }
    public Date getStorageTime(){
    return this.storageTime;
    }

    public String getBillTime() {
        return billTime;
    }

    public void setBillTime(String billTime) {
        this.billTime = billTime;
    }

    public void setWarehouseCode(String warehouseCode){
    this.warehouseCode = warehouseCode;
    }
    public String getWarehouseCode(){
    return this.warehouseCode;
    }
    public void setWarehouseName(String warehouseName){
    this.warehouseName = warehouseName;
    }
    public String getWarehouseName(){
    return this.warehouseName;
    }
    public void setOpLongCode(String opLongCode){
    this.opLongCode = opLongCode;
    }
    public String getOpLongCode(){
    return this.opLongCode;
    }
    public void setItemName(String itemName){
    this.itemName = itemName;
    }
    public String getItemName(){
    return this.itemName;
    }
    public void setBatch(String batch){
    this.batch = batch;
    }
    public String getBatch(){
    return this.batch;
    }
    public void setLogicWarehouseCode(String logicWarehouseCode){
    this.logicWarehouseCode = logicWarehouseCode;
    }
    public String getLogicWarehouseCode(){
    return this.logicWarehouseCode;
    }
    public void setLogicWarehouseName(String logicWarehouseName){
    this.logicWarehouseName = logicWarehouseName;
    }
    public String getLogicWarehouseName(){
    return this.logicWarehouseName;
    }
    public void setChargeOrgId(Long chargeOrgId){
    this.chargeOrgId = chargeOrgId;
    }
    public Long getChargeOrgId(){
    return this.chargeOrgId;
    }
    public void setChargeOrgName(String chargeOrgName){
    this.chargeOrgName = chargeOrgName;
    }
    public String getChargeOrgName(){
    return this.chargeOrgName;
    }
    public void setInitialInventoryNum(Integer initialInventoryNum){
    this.initialInventoryNum = initialInventoryNum;
    }
    public Integer getInitialInventoryNum(){
    return this.initialInventoryNum;
    }
    public void setInDeliveryNum(Integer inDeliveryNum){
    this.inDeliveryNum = inDeliveryNum;
    }
    public Integer getInDeliveryNum(){
    return this.inDeliveryNum;
    }
    public void setOutDeliveryNum(Integer outDeliveryNum){
    this.outDeliveryNum = outDeliveryNum;
    }
    public Integer getOutDeliveryNum(){
    return this.outDeliveryNum;
    }
    public void setEndInventoryNum(Integer endInventoryNum){
    this.endInventoryNum = endInventoryNum;
    }
    public Integer getEndInventoryNum(){
    return this.endInventoryNum;
    }
    public void setAdjustType(Integer adjustType){
    this.adjustType = adjustType;
    }
    public Integer getAdjustType(){
    return this.adjustType;
    }
    public void setAdjustDeliveryNum(Integer adjustDeliveryNum){
    this.adjustDeliveryNum = adjustDeliveryNum;
    }
    public Integer getAdjustDeliveryNum(){
    return this.adjustDeliveryNum;
    }
    public void setRemark(String remark){
    this.remark = remark;
    }
    public String getRemark(){
    return this.remark;
    }

    public Integer getZhTrayNum() {
        return zhTrayNum;
    }

    public void setZhTrayNum(Integer zhTrayNum) {
        this.zhTrayNum = zhTrayNum;
    }

    public void setPackingQuantity(Integer packingQuantity){
    this.packingQuantity = packingQuantity;
    }
    public Integer getPackingQuantity(){
    return this.packingQuantity;
    }

    public BigDecimal getAllOutVolume() {
        return allOutVolume;
    }

    public void setAllOutVolume(BigDecimal allOutVolume) {
        this.allOutVolume = allOutVolume;
    }

    public void setAllDaySupport(Integer allDaySupport){
    this.allDaySupport = allDaySupport;
    }
    public Integer getAllDaySupport(){
    return this.allDaySupport;
    }
    public void setOrganizationSupport(BigDecimal organizationSupport){
    this.organizationSupport = organizationSupport;
    }
    public BigDecimal getOrganizationSupport(){
    return this.organizationSupport;
    }

    public Integer getBizType() {
        return bizType;
    }

    public void setBizType(Integer bizType) {
        this.bizType = bizType;
    }

    public String getExceptionInfo() {
        return exceptionInfo;
    }

    public void setExceptionInfo(String exceptionInfo) {
        this.exceptionInfo = exceptionInfo;
    }

    public void setOrgId(Long orgId){
    this.orgId = orgId;
    }
    public Long getOrgId(){
    return this.orgId;
    }

    public Long getBelongOrgId() {
        return belongOrgId;
    }

    public void setBelongOrgId(Long belongOrgId) {
        this.belongOrgId = belongOrgId;
    }

    public String getBelongOrgName() {
        return belongOrgName;
    }

    public void setBelongOrgName(String belongOrgName) {
        this.belongOrgName = belongOrgName;
    }

    public Integer getPlacedFlag() {
        return placedFlag;
    }

    public void setPlacedFlag(Integer placedFlag) {
        this.placedFlag = placedFlag;
    }

    public String getChargeOrgCode() {
        return chargeOrgCode;
    }

    public void setChargeOrgCode(String chargeOrgCode) {
        this.chargeOrgCode = chargeOrgCode;
    }
}
