package com.dtyunxi.tcbj.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.InventoryDetailReportListPageReqDto;
import com.dtyunxi.tcbj.api.dto.response.InventoryDetailReportPageListRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.Date;

/**
 * 库存收发明细报表服务接口
 *
 * @author fengjian
 * @since 2022-07-07
 */
@Api(tags = {"库存收发明细报表服务"})
@FeignClient(
        name = "${tcbj.center.report.name:tcbj-center-report}",
        path = "/v1/inventoryDetailReport",
        url = "${tcbj.center.report.api:}"
)
public interface IInventoryDetailReportQueryApi {

    /**
     * 库存收发明细报表分页列表
     *
     * @param dto 查询条件
     * @return 库存收发明细报表分页列表
     */
    @PostMapping("")
    @ApiOperation(value = "库存收发明细报表分页列表", notes = "根据filter查询条件查询库存收发明细报表数据，filter=InventoryDetailReportListPageReqDto")
    RestResponse<PageInfo<InventoryDetailReportPageListRespDto>> queryInventoryDetailReport(@RequestBody InventoryDetailReportListPageReqDto dto);


    @GetMapping("executeJob")
    RestResponse<Void> executeJob(@RequestParam(value = "date")@DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss") Date date);

}
