package com.dtyunxi.tcbj.api.dto.response;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.Valid;

/**
 * @description:
 * @author: yuangui
 * @date: 2022-03-18 10:38
 */
@Data
public class CompanyRespDto {
    @ApiModelProperty(name="createTime", value = "创建时间")
    @JsonProperty("createTime")
    private String createTime;


    @ApiModelProperty(name="updateTime", value = "更新时间")
    @JsonProperty("updateTime")
    private String updateTime;


    @ApiModelProperty(name="createPerson", value = "创建人")
    @JsonProperty("createPerson")
    private String createPerson;


    @ApiModelProperty(name="updatePerson", value = "更新人")
    @JsonProperty("updatePerson")
    private String updatePerson;


    @ApiModelProperty(name="id", value = "唯一id")
    @JsonProperty("id")
    private Long id;


    @ApiModelProperty(name="creditCode", value = "社会统一代码")
    @JsonProperty("creditCode")
    private String creditCode;


    @ApiModelProperty(name="orgName", value = "公司名称")
    @JsonProperty("orgName")
    private String orgName;


    @ApiModelProperty(name="businessLicenseType", value = "执照类型")
    @JsonProperty("businessLicenseType")
    private String businessLicenseType;


    @ApiModelProperty(name="termBeginTime", value = "营业期限开始日期")
    @JsonProperty("termBeginTime")
    private String termBeginTime;


    @ApiModelProperty(name="termEndTime", value = "营业期限结束日期")
    @JsonProperty("termEndTime")
    private String termEndTime;


    @Valid
    @ApiModelProperty(name="area", value = "")
    @JsonProperty("area")
    private AddressRespDto area;


    @ApiModelProperty(name="legalName", value = "法定代表人")
    @JsonProperty("legalName")
    private String legalName;


    @ApiModelProperty(name="legalCardType", value = "法人证件类型")
    @JsonProperty("legalCardType")
    private String legalCardType;


    @ApiModelProperty(name="legalCardNum", value = "法人证件号码")
    @JsonProperty("legalCardNum")
    private String legalCardNum;


    @ApiModelProperty(name="cardEffectBeginTime", value = "法人证件有效期开始日期")
    @JsonProperty("cardEffectBeginTime")
    private String cardEffectBeginTime;


    @ApiModelProperty(name="cardEffectEndTime", value = "法人证件有效期结束日期")
    @JsonProperty("cardEffectEndTime")
    private String cardEffectEndTime;


    @ApiModelProperty(name="idCardFront", value = "法人证件正面照")
    @JsonProperty("idCardFront")
    private String idCardFront;


    @ApiModelProperty(name="idCardBack", value = "法人证件反面照")
    @JsonProperty("idCardBack")
    private String idCardBack;


    @ApiModelProperty(name="bussinessLicenseUrl", value = "营业执照")
    @JsonProperty("bussinessLicenseUrl")
    private String bussinessLicenseUrl;


    @ApiModelProperty(name="companyId", value = "公司ID")
    @JsonProperty("companyId")
    private String companyId;
}
