/**
 * @(#) GetSaleReturnOrderListPageParams.java 1.0 2022/1/5/005
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.tcbj.api.dto.request.es;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * GetSaleReturnOrderListPageParams
 */
@Data
@ApiModel(value = "GetSaleReturnOrderListPageParams", description = "")
public class EsSaleReturnOrderListPageParams extends EsBaseReqParams{

  @NotNull(message = "分页参数不能为空")
  @ApiModelProperty(name="pageSize", required = true, value = "分页大小")
  private Integer pageSize;

  @NotNull(message = "分页参数不能为空")
  @ApiModelProperty(name="pageNum", required = true, value = "当前分页")
  private Integer pageNum;
  
  
  @ApiModelProperty(name="saleReturnOrderNo", value = "销售退货单号")
  private String saleReturnOrderNo;


  @ApiModelProperty(name="saleReturnOrderNoList", value = "销售退货单号列表")
  private List<String> saleReturnOrderNoList;
  
  @ApiModelProperty(name="outBizOrderNo", value = "外部业务单号")
  private String outBizOrderNo;

  @ApiModelProperty(name="outBizOrderNoList", value = "外部业务单号列表")
  private List<String> outBizOrderNoList;
  
  
  @ApiModelProperty(name="returnType", value = "退货类型")
  private String returnType;
  
  
  @ApiModelProperty(name="orderStatus", value = "状态")
  private String orderStatus;
  
  
  @ApiModelProperty(name="returnCustomerName", value = "退货客户名称")
  private String returnCustomerName;


  @ApiModelProperty(name="planLogicalWarehouseName", value = "计划退货逻辑仓名称")
  private String planLogicalWarehouseName;
  
  
  @ApiModelProperty(name="actualLogicalWarehouseName", value = "实际退货逻辑仓名称")
  private String actualLogicalWarehouseName;
  
  
  @ApiModelProperty(name="bizOrderCreateTimeStart", value = "业务单创建日期开始")
  private String bizOrderCreateTimeStart;
  
  
  @ApiModelProperty(name="bizOrderCreateTimeEnd", value = "业务单创建时间结束")
  private String bizOrderCreateTimeEnd;
  
  
  @ApiModelProperty(name="actualReturnTimeStart", value = "实际退货日期开始")
  private String actualReturnTimeStart;
  
  
  @ApiModelProperty(name="actualReturnTimeEnd", value = "实际退货日期结束")
  private String actualReturnTimeEnd;
  
  
  @ApiModelProperty(name="saleOrganizationName", value = "销售组织名称")
  private String saleOrganizationName;
  
  
  @ApiModelProperty(name="createTimeStart", value = "销售退货单创建日期开始")
  private String createTimeStart;
  
  
  @ApiModelProperty(name="createTimeEnd", value = "销售退货单创建日期结束")
  private String createTimeEnd;
  
}

