package com.dtyunxi.tcbj.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.ExpressCostReportQueryDto;
import com.dtyunxi.tcbj.api.dto.UpdateBillOrgDto;
import com.dtyunxi.tcbj.api.dto.request.*;
import com.dtyunxi.tcbj.api.dto.response.ExpressCostChargingRespDto;
import com.dtyunxi.tcbj.api.dto.response.ReInsuranceBillCountDto;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.report.dto.entity.MasterOrderDifferenceDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.simpleframework.xml.core.Validate;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@Api(tags = {"快递计费明细报表详情服务"})
@FeignClient(
        name = "${tcbj.center.report.api.name:tcbj-center-report}",
        path = "/v1/express/cost/charging",
        url = "${tcbj.center.report.api:}"
)
public interface IExpressCostChargingApi {

    @PostMapping("/add")
    @ApiOperation(value = "新增快递计费明细报表详情", notes = "新增快递计费明细报表详情")
    RestResponse<Long> addExpressCostCharging(@RequestBody ExpressCostChargingReqDto addReqDto);

    @DeleteMapping("/{id}")
    @ApiOperation(value = "删除快递计费明细报表详情", notes = "删除快递计费明细报表详情")
    RestResponse<Void> removeExpressCostCharging(@PathVariable("id") Long id);

    @PostMapping("/againCalculate")
    @ApiOperation(value = "更新账单数据", notes = "更新账单数据")
    RestResponse<Void> againCalculate(@RequestBody AgainCalculateReqDto reqDto);

    @PostMapping("/generateExpressCostData")
    @ApiOperation(value = "快递费-生成快递报表", notes = "快递费-生成快递报表")
    RestResponse<Void> generateExpressCostData(@RequestBody LogisticStatisticReqDto reqDto);

    @PostMapping("/generateInsurance")
    @ApiOperation(value = "根据每日发货报表生成快递费明细", notes = "根据每日发货报表生成快递费明细")
    RestResponse<Void> generateInsurance(@RequestBody FeeGenerateReqDto reqDto);

    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询快递计费明细报表详情", notes = "根据id查询快递计费明细报表详情")
    RestResponse<ExpressCostChargingRespDto> queryById(@PathVariable("id") Long id);

    @PostMapping("/page")
    @ApiOperation(value = "快递计费明细报表详情分页数据", notes = "快递计费明细报表详情查询条件")
    RestResponse<PageInfo<ExpressCostChargingRespDto>> queryByPage(@RequestBody ExpressCostReportQueryDto queryDto);

    @PostMapping("/queryExpressCount")
    @ApiOperation(value = "快递计费明细报表统计数据", notes = "快递计费明细报表统计数据")
    RestResponse<ReInsuranceBillCountDto> queryExpressCount(@RequestBody(required = false) ExpressCostReportQueryDto queryDto);

    @PostMapping("/queryListByExpressOrders")
    @ApiOperation(value = "快递费-快递费报表查询(快递单号)", notes = "快递费-快递费报表查询(快递单号)")
    RestResponse<List<ExpressCostChargingRespDto>> queryListByExpressOrders(@RequestBody List<String> orderNos);

    @PostMapping("/queryList")
    @ApiOperation(value = "快递计费明细报表列表查询", notes = "快递计费明细报表列表查询")
    RestResponse<List<ExpressCostChargingRespDto>> queryList(@RequestBody ExpressCostChargingReqDto reqDto);

    @PostMapping("/queryPageMasterOrderDifference")
    @ApiOperation(value = "分页查询总单差异信息", notes = "分页查询总单差异信息")
    RestResponse<PageInfo<MasterOrderDifferenceDto>> queryPageMasterOrderDifference(@RequestBody ExpressCostReportQueryDto reqDto);

    @PostMapping("/updatePlaceStatus")
    @ApiOperation(value = "快递计费明细报表更新归档标识", notes = "快递计费明细报表更新归档标识")
    RestResponse<Integer> updatePlaceStatus(@RequestBody @Validated FeeReportPlaceUpdateReqDto updateReqDto);

    @PostMapping(path = "/updateBillOrg")
    @ApiOperation(value = "修改计费组织", notes = "修改计费组织")
    RestResponse<Void> updateBillOrg(@RequestBody @Validate UpdateBillOrgDto reqDto);

    @PostMapping(path = "/hasPlacedFlag")
    @ApiOperation(value = "查询计费明细是否存在归档数据", notes = "查询计费明细是否存在归档数据")
    RestResponse<Boolean> hasPlacedFlag(@RequestBody ExpressCostReportQueryDto dto);


}
