package com.dtyunxi.tcbj.api.dto.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.util.List;

/**
 * @author jack
 * @version 1.0
 * @date 02/09/2022 19:17
 **/
@ApiModel(value = "SkuInventoryBatchReqDto", description = "sku库存统计请求对象")
@Getter
@Setter
public class SkuInventoryBatchReqDto {

    @ApiModelProperty(name = "skuCode", value = "货品编码")
    private String skuCode;


    @ApiModelProperty(name = "skuCodeList", value = "货品编码集合")
    private List<String> skuCodeList;

    @ApiModelProperty(name = "batch", value = "批次")
    private String batch;

    @ApiModelProperty(name = "warehouseCode", value = "逻辑仓库编码")
    private String warehouseCode;

    @ApiModelProperty(name = "warehouseCodeList", value = "逻辑仓库编码集合")
    private List<String> warehouseCodeList;


    @ApiModelProperty(name = "warehouseName", value = "逻辑仓库名称")
    private String warehouseName;


    @ApiModelProperty(name = "physicsWarehouseCode", value = "物理仓库编码")
    private String physicsWarehouseCode;


    @ApiModelProperty(name = "physicsWarehouseCodeList", value = "物理仓库编码集合")
    private List<String> physicsWarehouseCodeList;

    private String physicsWarehouseName;

    @ApiModelProperty(name = "organizationCode", value = "组织编码")
    private String organizationCode;

    @ApiModelProperty(name = "organizationCodeList", value = "组织编码集合")
    private List<String> organizationCodeList;



}
