package com.dtyunxi.tcbj.api.dto.response;

import com.dtyunxi.dto.BaseRespDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import java.math.BigDecimal;

/**
* 关联供货库存Eo对象
*
* @author guigu
* @since 2022-07-13
*/
@ApiModel(value = "RelShareInventoryRespDto", description = "关联供货库存Eo对象")
@Data
public class RelShareInventoryRespDto extends BaseRespDto{
    /**
    *  主键id
    */
    @ApiModelProperty(name = "id", value = "主键id")
    private Long id;
    /**
    *  供货类型，tovirtual,tochannel
    */
    @ApiModelProperty(name = "shareWarehouseType", value = "供货类型，tovirtual,tochannel")
    private String shareWarehouseType;
    /**
    *  供货i仓库编码，类型是tovirtual，供货仓是逻辑仓，类型是tochannel，供货仓是虚仓
    */
    @ApiModelProperty(name = "shareWarehouseCode", value = "供货i仓库编码，类型是tovirtual，供货仓是逻辑仓，类型是tochannel，供货仓是虚仓")
    private String shareWarehouseCode;
    /**
    *  接受供货仓库编码
    */
    @ApiModelProperty(name = "receiveWarehouseCode", value = "接受供货仓库编码")
    private String receiveWarehouseCode;
    /**
    *  供货商品编码
    */
    @ApiModelProperty(name = "cargoCode", value = "供货商品编码")
    private String cargoCode;

    @ApiModelProperty(name = "itemName", value = "商品名称")
    private String itemName;
    /**
    *  总库存
    */
    @ApiModelProperty(name = "balance", value = "总库存")
    private BigDecimal balance;
    /**
    *  预占库存
    */
    @ApiModelProperty(name = "preempt", value = "预占库存")
    private BigDecimal preempt;
    /**
    *  可用库存
    */
    @ApiModelProperty(name = "available", value = "可用库存")
    private BigDecimal available;
    /**
    *  版本：0.迁移旧数据，1.一期迭代二，2.二期
    */
    @ApiModelProperty(name = "version", value = "版本：0.迁移旧数据，1.一期迭代二，2.二期")
    private Integer version;

    @ApiModelProperty(name = "shareWarehouseName", value = "供货仓库名称")
    private String shareWarehouseName;

    @ApiModelProperty(name = "shareWarehouseTypeName", value = "供货仓类型名称")
    private String shareWarehouseTypeName;

    /**
     *  共享比例
     */
    @ApiModelProperty(name = "shareRatio", value = "共享比例")
    private BigDecimal shareRatio;

    @ApiModelProperty(name = "batch", value = "批次")
    private String batch;

}
