package com.dtyunxi.tcbj.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.InspectionReleasePlanReqDto;
import com.dtyunxi.tcbj.api.dto.response.InspectionReleasePlanRespDto;
import com.dtyunxi.tcbj.api.dto.response.LogicInventoryRespDto;
import com.dtyunxi.tcbj.api.dto.response.QualityInfoDetailReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;
import com.github.pagehelper.PageInfo;

import java.util.List;

/**
* 计划放行服务接口
*
* @author 紫霄
* @since 2023-05-10
*/
@Api(tags = {"计划放行服务"})
@FeignClient(
    contextId = "com-dtyunxi-tcbj-api-query-IInspectionReleasePlanQueryApi",
    name = "${tcbj.center.report.api.name:tcbj-center-report}",
    path = "/v1/inspectionReleasePlan",
    url = "${tcbj.center.report.api:}"
)
public interface IInspectionReleasePlanQueryApi {

    /**
    * 根据id查询计划放行
    *
    * @param id 计划放行id
    * @return   计划放行数据
    */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询计划放行", notes = "根据id查询计划放行")
    RestResponse<InspectionReleasePlanRespDto> queryById(@PathVariable("id") Long id);

    /**
    * 计划放行分页数据
    *
    * @param filter   计划放行查询条件
    * @param pageNum  当前页
    * @param pageSize 页大小
    * @return 计划放行分页数据
    */
    @GetMapping("/page")
    @ApiOperation(value = "计划放行分页数据", notes = "根据filter查询条件查询计划放行数据，filter=InspectionReleasePlanReqDto")
    RestResponse<PageInfo<InspectionReleasePlanRespDto>> queryByPage(@RequestParam("filter") String filter,
                                                           @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                           @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);

    @PostMapping("/queryBatchByPage")
    @ApiOperation(value = "根据商品长编码或者批次查询计划放行数据", notes = "根据filter查询条件查询计划放行数据，filter=InspectionReleasePlanReqDto")
    RestResponse<List<InspectionReleasePlanRespDto>> queryBatchByPage(@RequestBody InspectionReleasePlanReqDto dto);


    @PostMapping("/queryAvailableByPage")
    @ApiOperation(value = "根据商品长编码和批次查询待检仓的即时库存", notes = "根据filter查询条件查询计划放行数据，filter=InspectionReleasePlanReqDto")
    RestResponse<List<LogicInventoryRespDto>> queryAvailableByPage(@RequestBody InspectionReleasePlanReqDto dto);

}
