package com.dtyunxi.tcbj.api.dto.response;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.Valid;
import java.math.BigDecimal;

/**
 * 销售订单统计dto
 *
 * @author haoxiao
 * @since 2022-03-10
 */
@Data
@ApiModel(value = "SaleOrderCountRespDto", description = "销售订单统计dto")
public class SaleOrderCountRespDto {
    @Valid
    @ApiModelProperty(name="waitCheckCount", value = "待确认数量")
    @JsonProperty("waitCheckCount")
    private BigDecimal waitCheckCount;


    @Valid
    @ApiModelProperty(name="waitPickCount", value = "待配货数量")
    @JsonProperty("waitPickCount")
    private BigDecimal waitPickCount;


    @Valid
    @ApiModelProperty(name="lockUnDeliveryCount", value = "已锁未发/已配货数量")
    @JsonProperty("lockUnDeliveryCount")
    private BigDecimal lockUnDeliveryCount;


    @Valid
    @ApiModelProperty(name="waitDeliveryCount", value = "待发货数量")
    @JsonProperty("waitDeliveryCount")
    private BigDecimal waitDeliveryCount;


    @Valid
    @ApiModelProperty(name="deliveredCount", value = "已发货数量")
    @JsonProperty("deliveredCount")
    private BigDecimal deliveredCount;


    @Valid
    @ApiModelProperty(name="completeCount", value = "已完成数量")
    @JsonProperty("completeCount")
    private BigDecimal completeCount;


    @Valid
    @ApiModelProperty(name="cancelCount", value = "已取消数量")
    @JsonProperty("cancelCount")
    private BigDecimal cancelCount;


    @Valid
    @ApiModelProperty(name="cancelingCount", value = "取消中数量")
    @JsonProperty("cancelingCount")
    private BigDecimal cancelingCount;


    @Valid
    @ApiModelProperty(name="finishCount", value = "已完结数量")
    @JsonProperty("finishCount")
    private BigDecimal finishCount;


    @Valid
    @ApiModelProperty(name="splitCount", value = "被拆分数量")
    @JsonProperty("splitCount")
    private BigDecimal splitCount;


    @Valid
    @ApiModelProperty(name="allCount", value = "全部数量")
    @JsonProperty("allCount")
    private BigDecimal allCount;


    @Valid
    @ApiModelProperty(name="obsoleteCount", value = "已作废数量")
    @JsonProperty("obsoleteCount")
    private BigDecimal obsoleteCount;


    @Valid
    @ApiModelProperty(name="receivedCount", value = "已签收数量")
    @JsonProperty("receivedCount")
    private BigDecimal receivedCount;

    @Valid
    @ApiModelProperty(name="lockCount", value = "挂起数量")
    @JsonProperty("lockCount")
    private BigDecimal lockCount;

    @Valid
    @ApiModelProperty(name="presaleOrderCount", value = "预售订单数量")
    @JsonProperty("presaleOrderCount")
    private BigDecimal presaleOrderCount;

    @Valid
    @ApiModelProperty(name="alreadyPickCount", value = "已配货")
    @JsonProperty("alreadyPickCount")
    private BigDecimal alreadyPickCount;

    @ApiModelProperty(name="overdueDeliveryCount", value = "超期未发数量")
    @JsonProperty("overdueDeliveryCount")
    private BigDecimal overdueDeliveryCount;

    @ApiModelProperty(name="overdueReceivedTime", value = "超期未收数量")
    @JsonProperty("overdueReceivedTime")
    private BigDecimal overdueReceivedTime;

}
