package com.dtyunxi.tcbj.api.dto.constant.enums;

import org.apache.commons.collections.CollectionUtils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @description: PCP客户详情枚举类
 * @author: yuangui
 * @date: 2022-03-19 16:22
 */
public enum PCPCustomerDetailEnum {
    NONE(0,"无须其他数据"),
    ALL(1, "全部"),
    ADDRESS(2,"地址"),
    SALESMAN(3,"业务员"),
    COMPANY(4,"公司信息"),
    CONTACTS(5,"联系人"),
    STATUS(6,"状态"),
    TYPE(7,"类型"),
    LEVEL(8,"级别");
    private Integer code;

    private String value;

    PCPCustomerDetailEnum(Integer code, String value) {
        this.code = code;
        this.value = value;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getValue() {
        return value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public static List<PCPCustomerDetailEnum> getValueByCode(List<Integer> codes){
        if(CollectionUtils.isEmpty(codes)) {
            return null;
        }
        if(codes.contains(ALL.getCode())){
            return allEnum;
        }
        return Arrays.asList(values()).stream().filter(e->{return codes.contains(e.getCode());}).collect(Collectors.toList());
    }

    public static List<PCPCustomerDetailEnum> allEnum = Arrays.asList(values());
}
