package com.dtyunxi.tcbj.api.dto.request;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

@Data
public class RpInventoryPreemptionQueryDto {

    @ApiModelProperty(
            name = "sourceType",
            value = "单据类型,待定"
    )
    private String sourceType;

    @ApiModelProperty(
            name = "sourceType",
            value = "单据类型集合"
    )
    private List<String> sourceTypeList;

    @ApiModelProperty(
            name = "sourceNo",
            value = "来源单据号"
    )
    private String sourceNo;
    @ApiModelProperty(
            name = "warehouseId",
            value = "仓库ID"
    )
    private Long warehouseId;
    @ApiModelProperty(
            name = "warehouseCode",
            value = "仓库编码"
    )
    private String warehouseCode;
    @ApiModelProperty(
            name = "warehouseName",
            value = "仓库名称"
    )
    private String warehouseName;
    @ApiModelProperty(
            name = "warehouseClassify",
            value = "仓库分类:physics-物理仓,logic-逻辑仓,virtual-虚拟仓,channel-渠道仓"
    )
    private String warehouseClassify;
    @ApiModelProperty(
            name = "warehouseType",
            value = "仓库对应于不同层级仓库的类型"
    )
    private String warehouseType;
    @ApiModelProperty(
            name = "cargoId",
            value = "货品ID"
    )
    private Long cargoId;
    @ApiModelProperty(
            name = "cargoCode",
            value = "货品编码"
    )
    private String cargoCode;
    @ApiModelProperty(
            name = "cargoName",
            value = "货品名称"
    )
    private String cargoName;
    @ApiModelProperty(
            name = "artNo",
            value = "货品货号"
    )
    private String artNo;
    @ApiModelProperty(
            name = "batch",
            value = "批次"
    )
    private String batch;
    @ApiModelProperty(
            name = "batchType",
            value = "批次类型 common-正常,defective-残次品,其他类型待定"
    )
    private String batchType;
    @ApiModelProperty(
            name = "valid",
            value = "enable有效,disable无效"
    )
    private String valid;
    @ApiModelProperty(
            name = "activityId",
            value = "活动ID"
    )
    private Long activityId;
    @ApiModelProperty(
            name = "activityType",
            value = "活动类型"
    )
    private String activityType;
    @ApiModelProperty(
            name = "activityFlag",
            value = "是否为活动商品  0-否  1-是"
    )
    private Integer activityFlag;
    @ApiModelProperty(
            name = "remark",
            value = "备注"
    )
    private String remark;
    @ApiModelProperty(
            name = "pageNum",
            value = "页码"
    )
    private Integer pageNum;
    @ApiModelProperty(
            name = "pageSize",
            value = "每页条数"
    )
    private Integer pageSize;
    @ApiModelProperty(
            name = "orderByDesc",
            value = "排序，默认按照createTime降序"
    )
    private String orderByDesc = "createTime";
    @ApiModelProperty(
            name = "preemptNum",
            value = "预占的货品数量"
    )
    private BigDecimal preemptNum;
    @ApiModelProperty(
            name = "externalOrderNo",
            value = "外部单号"
    )
    private String externalOrderNo;
    @ApiModelProperty(
            name = "longCode",
            value = "货品长编码"
    )
    private String longCode;

    @ApiModelProperty(
            name = "warehouseCodeList",
            value = "仓库编码"
    )
    private List<String> warehouseCodeList;
    @ApiModelProperty(
            name = "cargoCodeList",
            value = "货品编码"
    )
    private List<String> cargoCodeList;

    @ApiModelProperty(
            name = "longCode",
            value = "渠道仓编码"
    )
    private String channelWarehouseCode;
    @ApiModelProperty(
            name = "longCode",
            value = "供货仓编码"
    )
    private String supplyWarehouseCode;
    @ApiModelProperty(
            name = "longCode",
            value = "逻辑仓编码"
    )
    private String logicalWarehouseCode;
    @ApiModelProperty(
            name = "longCode",
            value = "在途仓编码"
    )
    private String inTransitWarehouseCode;
    @ApiModelProperty(
            name = "startTime",
            value = "查询总预占库存数量起始时间"
    )
    private String startTime;
    @ApiModelProperty(
            name = "endTime",
            value = "查询总预占库存数量结束时间"
    )
    private String endTime;
}
