package com.dtyunxi.tcbj.api.dto.request;


import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;
import java.util.List;

/**
 * LogicalInventoryListPageParams
 * @author jack
 */
@Data
@ApiModel(value = "LogicInventoryListReqDto", description = "请求类")
public class LogicInventoryListReqDto {

    /**
     * 仓库ID
     */
    @ApiModelProperty(name = "warehouseId", value = "仓库ID")
    private Long logicWarehouseId;
    /**
     * 仓库编码
     */
    @ApiModelProperty(name = "warehouseCode", value = "仓库编码")
    private String logicWarehouseCode;

    /**
     * 仓库编码集合
     */
    @ApiModelProperty(name = "logicWarehouseCodeList", value = "仓库编码集合")
    private List<String> logicWarehouseCodeList;



    /**
     * 货品编码
     */
    @ApiModelProperty(name = "skuCodeList", value = "货品编码列表")
    private List<String> skuCodeList;

    @ApiModelProperty(name = "notSkuCodeList", value = "不包括货品编码列表")
    private List<String> notSkuCodeList;


    /**
     * 货品编码
     */
    @ApiModelProperty(name = "skuCode", value = "货品编码")
    private String skuCode;

    @ApiModelProperty(name = "skuName", value = "货品名称")
    private String skuName;
    /**
     * 批次
     */
    @ApiModelProperty(name = "batch", value = "批次")
    private String batch;
    /**
     * 批次集合
     */
    @ApiModelProperty(name = "batchList", value = "批次集合")
    private List<String> batchList;
    /**
     * 批次类型 common-正常,defective-残次品,其他类型待定
     */
    @ApiModelProperty(name = "batchType", value = "批次类型 common-正常,defective-残次品,其他类型待定")
    private String batchType;
    /**
     * 货品长编码
     */
    @ApiModelProperty(name = "longCode", value = "货品长编码")
    private String longCode;

    @ApiModelProperty(name = "filterLongCodes", value = "过滤长编码")
    private List<String> filterLongCodes;

    @ApiModelProperty(name = "unLikeBatch", value = "过滤批次")
    private String unLikeBatch;
    /**
     * 货品长编码集合
     */
    @ApiModelProperty(name = "longCodes", value = "货品长编码集合")
    private List<String> longCodes;

    @ApiModelProperty(name = "filterGtZero", required = true, value = "是否过滤可用大于0的记录：true-过滤，false/null-不过滤")
    private Boolean filterGtZero = false;

    private Boolean filterZero = false;

    @ApiModelProperty(name = "filterProduceTime", required = true, value = "是否过滤不存在生产日期的数据")
    private Boolean filterProduceTime = false;

    /**
     * 库存组织集合
     */
    @ApiModelProperty(name = "organizationCodeList", value = "库存组织集合")
    private List<String> organizationCodeList;

    /**
     * 物理仓编码
     */
    @ApiModelProperty(name = "physicsWarehouseCodeList", value = "物理仓编码")
    private List<String> physicsWarehouseCodeList;

    /**
     * 物理仓状态
     */
    @ApiModelProperty(name = "physicsWarehouseStatus", value = "物理仓状态 enable disable")
    private String physicsWarehouseStatus;

    /**
     * 物理仓类型
     */
    @ApiModelProperty(name = "physicsWarehouseType", value = "物理仓类型")
    private String physicsWarehouseType;

    /**
     * 物理仓是否RDC
     */
    @ApiModelProperty(name = "isRdc", value = "物理仓是否RDC 1 是 0 否")
    private Integer isRdc;


    /**
     * 是否查询快照
     */
    @ApiModelProperty(name = "querySnap", value = "是否查询快照 1 是 0 否")
    private Integer querySnap = 0;

    /**
     * 是否查询快照
     */
    @ApiModelProperty(name = "querySnapDate", value = "快照查询日期")
    private Date querySnapDate;

    /**
     * 仓库品质
     */
    @ApiModelProperty(name = "logicWarehouseQuality", value = "仓库品质")
    private String logicWarehouseQuality;

    @ApiModelProperty(name = "logicWarehouseQualityList", value = "仓库品质")
    private List<String> logicWarehouseQualityList;

    @ApiModelProperty(name = "logicWarehouseClassify", value = "仓库分类")
    private String logicWarehouseClassify;

}
