package com.dtyunxi.tcbj.api.dto.response;

import com.dtyunxi.dto.BaseRespDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import java.math.BigDecimal;
import java.util.Date;


/**
* 逻辑仓库存快照表Eo对象
*
* @author mc
* @since 2022-10-13
*/
@Getter
@Setter
@ApiModel(value = "LogicInventorySnapRespDto", description = "逻辑仓库存快照表Eo对象")
public class LogicInventorySnapRespDto extends BaseRespDto{
    /**
    *  主键id
    */
    @ApiModelProperty(name = "id", value = "主键id")
    private Long id;
    /**
    *  仓库ID
    */
    @ApiModelProperty(name = "warehouseId", value = "仓库ID")
    private Long warehouseId;
    /**
    *  仓库编码
    */
    @ApiModelProperty(name = "warehouseCode", value = "仓库编码")
    private String warehouseCode;
    /**
    *  仓库名称
    */
    @ApiModelProperty(name = "warehouseName", value = "仓库名称")
    private String warehouseName;
    /**
    *  统计时间
    */
    @ApiModelProperty(name = "statisticalTime", value = "统计时间")
    private Date statisticalTime;
    /**
     *  统计时间
     */
    @ApiModelProperty(name = "statisticalTimeStr", value = "统计时间")
    private String statisticalTimeStr;
    /**
    *  货品ID
    */
    @ApiModelProperty(name = "cargoId", value = "货品ID")
    private Long cargoId;
    /**
    *  商品长编码
    */
    @ApiModelProperty(name = "longCode", value = "商品长编码")
    private String longCode;
    /**
    *  货品名称
    */
    @ApiModelProperty(name = "cargoName", value = "货品名称")
    private String cargoName;
    /**
    *  批次
    */
    @ApiModelProperty(name = "batch", value = "批次")
    private String batch;
    /**
    *  批次类型 common-正常,defective-残次品,其他类型待定
    */
    @ApiModelProperty(name = "batchType", value = "批次类型 common-正常,defective-残次品,其他类型待定")
    private String batchType;
    /**
    *  总库存
    */
    @ApiModelProperty(name = "balance", value = "总库存")
    private BigDecimal balance;
    /**
    *  预占库存
    */
    @ApiModelProperty(name = "preempt", value = "预占库存")
    private BigDecimal preempt;
    /**
    *  已分配库存
    */
    @ApiModelProperty(name = "allocate", value = "已分配库存")
    private BigDecimal allocate;
    /**
    *  活动分配库存
    */
    @ApiModelProperty(name = "activityAllocate", value = "活动分配库存")
    private BigDecimal activityAllocate;
    /**
    *  在途库存
    */
    @ApiModelProperty(name = "intransit", value = "在途库存")
    private BigDecimal intransit;
    /**
    *  已调拨库存
    */
    @ApiModelProperty(name = "transfer", value = "已调拨库存")
    private BigDecimal transfer;
    /**
    *  已完成库存
    */
    @ApiModelProperty(name = "completed", value = "已完成库存")
    private BigDecimal completed;
    /**
    *  待收库存
    */
    @ApiModelProperty(name = "futureIn", value = "待收库存")
    private BigDecimal futureIn;
    /**
    *  待退库存
    */
    @ApiModelProperty(name = "futureRetreat", value = "待退库存")
    private BigDecimal futureRetreat;
    /**
    *  可用库存,可用库存 = 总库存  - 预占库存 - 已分配库存 - 已调拨库存 - 活动分配库存
    */
    @ApiModelProperty(name = "available", value = "可用库存,可用库存 = 总库存  - 预占库存 - 已分配库存 - 已调拨库存 - 活动分配库存")
    private BigDecimal available;
    /**
    *  锁定库存
    */
    @ApiModelProperty(name = "lockInventory", value = "锁定库存")
    private BigDecimal lockInventory;
    /**
     *  物理仓库编码
     */
    @ApiModelProperty(name = "physicsWarehouseCode", value = "物理仓库编码")
    private String physicsWarehouseCode;
    /**
     *  物理仓库编码
     */
    @ApiModelProperty(name = "physicsWarehouseName", value = "物理仓库编码")
    private String physicsWarehouseName;
    /**
     *  库存组织编码
     */
    @ApiModelProperty(name = "organizationCode", value = "库存组织编码")
    private String organizationCode;
    /**
     *  库存组织名称
     */
    @ApiModelProperty(name = "organizationName", value = "库存组织名称")
    private String organizationName;
    /**
    *  板数
    */
    @ApiModelProperty(name = "boardNum", value = "板数")
    private Integer boardNum;
    /**
    *  码托数
    */
    @ApiModelProperty(name = "trayNum", value = "码托数")
    private Long trayNum;
    private Integer itemType;
    private String unit;
    private String specification;
    /**
    *  大箱数
    */
    @ApiModelProperty(name = "bigBox", value = "大箱数")
    private Integer bigBox;
    /**
    *  备注
    */
    @ApiModelProperty(name = "remark", value = "备注")
    private String remark;

    @ApiModelProperty(name = "warehouseType", value = "warehouseType")
    private String warehouseType;
    @ApiModelProperty(name = "warehouseQuality", value = "warehouseQuality")
    private String warehouseQuality;


    @ApiModelProperty(name = "purchaseIn", value = "采购入")
    private Long purchaseIn;
    @ApiModelProperty(name = "productionIn", value = "生产入")
    private Long productionIn;
    @ApiModelProperty(name = "outsourceIn", value = "委外入")
    private Long outsourceIn;
    @ApiModelProperty(name = "transferIn", value = "调拨入")
    private Long transferIn;
    @ApiModelProperty(name = "saleRefundIn", value = "销售退")
    private Long saleRefundIn;
    @ApiModelProperty(name = "purchaseOut", value = "采购退")
    private Long purchaseOut;
    @ApiModelProperty(name = "productionOut", value = "生产退")
    private Long productionOut;
    @ApiModelProperty(name = "outsourceOut", value = "委外退")
    private Long outsourceOut;
    @ApiModelProperty(name = "transferOut", value = "调拨出")
    private Long transferOut;
    @ApiModelProperty(name = "saleOut", value = "销售出")
    private Long saleOut;
    @ApiModelProperty(name = "otherOut", value = "其他出")
    private Long otherOut;
    @ApiModelProperty(name = "adjustNum", value = "盘点差异")
    private Long adjustIn;
    @ApiModelProperty(name = "otherIn", value = "其他入")
    private Long otherIn;
    @ApiModelProperty(name = "dateStart", value = "期初库存")
    private Long dateStart;
    @ApiModelProperty(name = "dateEnd", value = "期末库存")
    private Long dateEnd;
    @ApiModelProperty(name = "inventoryDiff", value = "库存差异")
    private Long inventoryDiff;

    @ApiModelProperty(name = "abnormalCauses", value = "异常原因")
    private String abnormalCauses;


    @ApiModelProperty(name = "errorMsg", value = "异常原因")
    private String errorMsg;

    @ApiModelProperty(name = "wmsBalance", value = "wms期末库存")
    private BigDecimal wmsBalance;

    @ApiModelProperty(name = "snapBalance", value = "期末库存")
    private BigDecimal snapBalance;

    @ApiModelProperty(name = "diffBalance", value = "期末库存差异")
    private BigDecimal diffBalance;

    @ApiModelProperty(name = "dayTotalBalance", value = "当日总库存")
    private BigDecimal dayTotalBalance;
    @ApiModelProperty(name = "dayTotalBoard", value = "当日总板数")
    private Integer dayTotalBoard;
}
