/**
 * @(#) InNoticeOrderVO.java 1.0 2022/1/5/005
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.tcbj.api.dto.response.es;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 计划类逆向出库单据实体
 */
@Data
@ApiModel(value = "InOutPlannedOrderVO", description = "计划类逆向出库单据实体")
public class OutPlannedOrderVO implements Serializable {

    @ApiModelProperty(name = "id", value = "唯一id")
    @JsonProperty("id")
    private Long id;

    /**
     * 平台单号(来源于第三方系统)
     */
    @ApiModelProperty(name = "platformOrderNo", value = "平台单号(来源于第三方系统)")
    private String platformOrderNo;

    @ApiModelProperty(name = "orderNo", value = "单据号,系统生成的计划类单据号")
    private String orderNo;

    /**
     * 单据类型:purchase-采购订单,outsource-委外订单,production-生产订单
     */
    @ApiModelProperty(name = "orderType", value = "单据类型")
    private String orderType;

    /**
     * 业务类型:purchase-采购促销订单,outsource-委外订单,production-生产订单
     */
    @ApiModelProperty(name = "businessType", value = "业务类型")
    private String businessType;
    /**
     * 单据状态:wait_submit-待提交,wait_audit-待审核,audit_failed-审核不通过,wait_in-待入库,cancel-已取消,portion_in-部分入库,completed-已完成,hang_up-挂起
     */
    @ApiModelProperty(name = "orderStatus", value = "单据状态")
    private String orderStatus;
    /**
     * 发货仓库ID
     */
    @ApiModelProperty(name = "deliveryWarehouseId", value = "发货仓库ID")
    private Long deliveryWarehouseId;
    /**
     * 发货仓库编码
     */
    @ApiModelProperty(name = "deliveryWarehouseCode", value = "发货仓库编码")
    private String deliveryWarehouseCode;
    /**
     * 发货仓库名称
     */
    @ApiModelProperty(name = "deliveryWarehouseName", value = "发货仓库名称")
    private String deliveryWarehouseName;
    /**
     * 供应商ID
     */
    @ApiModelProperty(name = "supplierId", value = "供应商ID")
    private Long supplierId;
    /**
     * 供应商编码
     */
    @ApiModelProperty(name = "supplierCode", value = "供应商编码")
    private String supplierCode;
    /**
     * 供应商名称
     */
    @ApiModelProperty(name = "supplierName", value = "供应商名称")
    private String supplierName;
    /**
     * 总数量
     */
    @ApiModelProperty(name = "totalQuantity", value = "总数量")
    private BigDecimal totalQuantity;
    /**
     * 已出总数量
     */
    @ApiModelProperty(name = "doneOutQuantity", value = "已出总数量")
    private BigDecimal doneOutQuantity;
    /**
     * 组织ID
     */
    @ApiModelProperty(name = "organizationId", value = "组织ID")
    private Long organizationId;
    /**
     * 组织名称
     */
    @ApiModelProperty(name = "organizationName", value = "组织名称")
    private String organizationName;
    /**
     * 创建人
     */
    @ApiModelProperty(name = "createPerson", value = "创建人")
    private String createPerson;

    @ApiModelProperty(name = "createTime", value = "创建时间")
    @JsonProperty("createTime")
    private Date createTime;

    private Long createTimeLong;

    @ApiModelProperty(name = "bizDate", value = "业务时间")
    private Date bizDate;

    /**
     * 商品长编码
     */
    @ApiModelProperty(name = "cargoCode", value = "商品长编码")
    private String cargoCode;

    /**
     * 商品名称
     */
    @ApiModelProperty(name = "cargoName", value = "商品名称")
    private String cargoName;

    /**
     * 批次
     */
    @ApiModelProperty(name = "batch", value = "批次")
    private String batch;

    /**
     * 备注
     */
    @ApiModelProperty(name = "remark", value = "备注")
    private String remark;

    /**
     * 已出库数量
     */
    @ApiModelProperty(name = "doneQuantity", value = "已出库数量")
    private BigDecimal doneQuantity;

    /**
     * 计划数量
     */
    @ApiModelProperty(name = "planQuantity", value = "计划数量")
    private BigDecimal planQuantity;

    /**
     * 待出库数量
     */
    @ApiModelProperty(name = "waitQuantity", value = "待出库数量")
    private BigDecimal waitQuantity;

    private String outPhysicsWarehouseCode;

    private String outPhysicsWarehouseName;
}

