package com.dtyunxi.tcbj.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.PhysicWarehouseStatisticsReqDto;
import com.dtyunxi.tcbj.api.dto.response.PhysicWarehouseStatisticsRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;

/**
* 物理仓板数统计服务接口
*
* @author 天泽
* @since 2022-08-24
*/
@Api(tags = {"物理仓板数统计服务"})
@FeignClient(
    contextId = "com-dtyunxi-tcbj-api-IPhysicWarehouseStatisticsApi",
    name = "${tcbj.center.report.name:tcbj-center-report}",
    path = "/v1/physicWarehouseStatistics",
    url = "${tcbj.center.report.api:}"
)
public interface IPhysicWarehouseStatisticsApi {

/**
* 新增物理仓板数统计
*
* @param addReqDto 物理仓板数统计请求对象
* @return 处理结果
*/
@PostMapping("")
@ApiOperation(value = "新增物理仓板数统计", notes = "新增物理仓板数统计")
RestResponse<Long> addPhysicWarehouseStatistics(@RequestBody PhysicWarehouseStatisticsReqDto addReqDto);

    /**
    * 修改物理仓板数统计
    *
    * @param modifyReqDto 物理仓板数统计请求对象
    * @return 处理结果
    */
    @PutMapping("")
    @ApiOperation(value = "修改物理仓板数统计", notes = "修改物理仓板数统计")
    RestResponse<Void> modifyPhysicWarehouseStatistics(@RequestBody PhysicWarehouseStatisticsReqDto modifyReqDto);

    /**
    * 删除物理仓板数统计
    *
    * @param ids        物理仓板数统计删除数据ID
    * @param instanceId 实例ID
    * @return 处理结果
    */
    @DeleteMapping("/{ids}")
    @ApiOperation(value = "删除物理仓板数统计", notes = "删除物理仓板数统计")
    RestResponse<Void> removePhysicWarehouseStatistics(@PathVariable("ids") String ids, @RequestParam("instanceId") Long instanceId);
}
