package com.dtyunxi.tcbj.api.dto;

import com.dtyunxi.vo.BaseVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;

import java.util.Date;

/**
 * @Description
 * @Author wude
 * @Since 1.0
 * @Date 2021/3/10 9:52
 **/
public class BaseDto extends BaseVo {
    @ApiModelProperty(
            name = "tenantId",
            value = "租户ID"
    )
    private Long tenantId;
    @ApiModelProperty(
            name = "instanceId",
            value = "实例ID"
    )
    private Long instanceId;
    @ApiModelProperty(
            name = "createPerson",
            value = "创建人"
    )
    private String createPerson;
    @ApiModelProperty(
            name = "createTime",
            value = "创建时间"
    )
    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm:ss"
    )
    private Date createTime;
    @ApiModelProperty(
            name = "updatePerson",
            value = "修改人"
    )
    private String updatePerson;
    @ApiModelProperty(
            name = "updateTime",
            value = "修改时间"
    )
    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm:ss"
    )
    private Date updateTime;
    @ApiModelProperty(
            name = "extension",
            value = "业务扩展字段"
    )
    private String extension;
    @ApiModelProperty(
            value = "是否分页 true分页 false不分页"
    )
    private Boolean needPage=Boolean.TRUE;
    @ApiModelProperty(
            value = "分页数"
    )
    private Integer pageNum=1;
    @ApiModelProperty(
            value = "分页大小"
    )
    private Integer pageSize=10;
    public Long getTenantId() {
        return tenantId;
    }

    public void setTenantId(Long tenantId) {
        this.tenantId = tenantId;
    }

    public Long getInstanceId() {
        return instanceId;
    }

    public void setInstanceId(Long instanceId) {
        this.instanceId = instanceId;
    }

    public String getCreatePerson() {
        return createPerson;
    }

    public void setCreatePerson(String createPerson) {
        this.createPerson = createPerson;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public String getUpdatePerson() {
        return updatePerson;
    }

    public void setUpdatePerson(String updatePerson) {
        this.updatePerson = updatePerson;
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public String getExtension() {
        return extension;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    public Integer getPageNum() {
        return pageNum;
    }

    public void setPageNum(Integer pageNum) {
        this.pageNum = pageNum;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public Boolean getNeedPage() {
        return needPage;
    }

    public void setNeedPage(Boolean needPage) {
        this.needPage = needPage;
    }
}
