package com.dtyunxi.tcbj.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.*;
import com.dtyunxi.tcbj.api.dto.response.*;
import com.dtyunxi.tcbj.api.vo.ChannelInventoryReportRespVo;
import com.dtyunxi.tcbj.api.vo.InventoryRespVo;
import com.dtyunxi.tcbj.api.vo.InventoryRespWithGiftPackageInfoVo;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * 库存查询接口
 *
 * @author shuyi
 * @date : 2021/12/7 10:39
 * @since 1.0.0
 */
@Api(tags = {"报表中心：查询库存信息"})
@FeignClient(
        name = "${tcbj.center.report.api.name:tcbj-center-report}",
        path = "/v1/inventory",
        url = "${tcbj.center.report.api:}"
)
public interface IInventoryReportQueryApi {

    /**
     * 根据商品编码集合查询商品预占信息列表
     * @param reqDto
     * @return
     */
    @PostMapping(value = {"/queryOrderOccupyQuantity"}, produces = "application/json")
    @ApiOperation(value = "根据商品编码集合查询商品预占信息列表", notes = "根据商品编码集合查询商品预占信息列表")
    RestResponse<List<CargoOccupyRespDto>> queryCargoOccupy(@RequestBody CargoOccupyReqDto reqDto);

    /**
     * 根据商品编码集合查询商品预占信息列表
     * @param
     * @return
     */
    @GetMapping(value = {"/queryPreemptSourceNo"}, produces = "application/json")
    @ApiOperation(value = "根据商品编码集合查询商品预占信息列表", notes = "根据商品编码集合查询商品预占信息列表")
    RestResponse<PageInfo<PreemptSourceNoRespDto>> queryPreemptSourceNo(@RequestParam(name = "pageNum", defaultValue = "1") Integer pageNum, @RequestParam(name = "pageSize", defaultValue = "1000") Integer pageSize, @RequestParam(name = "sourceNoList", required = false) List<String> sourceNoList);

    @PostMapping(value = {"/queryInventoryPage"}, produces = "application/json")
    @ApiOperation(value = "实时库存查询", notes = "实时库存查询")
    RestResponse<PageInfo<InventoryRespVo>> queryInventoryPage(@RequestBody InventoryQueryDto queryDto);

    @PostMapping(value = {"/queryInventoryWithGiftPackageInfoPage"}, produces = "application/json")
    @ApiOperation(value = "礼盒子批次库存查询", notes = "礼盒子批次库存查询")
    RestResponse<PageInfo<InventoryRespWithGiftPackageInfoVo>> queryInventoryWithGiftPackageInfoPage(@RequestBody InventoryQueryWithGiftPackageInfoDto queryDto);

    @PostMapping(value = {"/queryLogicTotalInventory"}, produces = "application/json")
    @ApiOperation(value = "逻辑仓总表库存查询", notes = "逻辑仓总表库存查询")
    RestResponse<List<CsLogicInventoryTotalRespDto>> queryLogicTotalInventory(@RequestBody CsLogicInventoryTotalQueryDto queryDto);

    @PostMapping(value = {"/queryOutOtherDetailReportPage"}, produces = "application/json")
    @ApiOperation(value = "其他出库明细报表分页", notes = "其他出库明细报表分页")
    RestResponse<PageInfo<OutOtherDetailReportRespDto>> queryOutOtherDetailReportPage(@RequestBody OutOtherDetailReportQueryDto queryDto);

    @PostMapping(value = {"/queryChannelInventoryPage"}, produces = "application/json")
    @ApiOperation(value = "查询渠道仓库存", notes = "查询渠道仓库存")
    RestResponse<PageInfo<ChannelInventoryRespDto>> queryChannelInventoryPage(@RequestBody InventoryQueryReqDto inventoryQueryReqDto);

    @PostMapping(value = {"/queryChannelInventoryReportPage"}, produces = "application/json")
    @ApiOperation(value = "渠道仓库存报表查询", notes = "渠道仓库存报表查询")
    RestResponse<PageInfo<ChannelInventoryReportRespVo>> queryChannelInventoryReportPage(@RequestBody ChannelInventoryReportQueryDto queryDto);

    @PostMapping("/queryChannelInventoryByCount")
    @ApiOperation(value = "渠道仓库存统计", notes = "根据filter查询条件查询渠道仓库存存表数据，filter=LogicInventoryReqDto")
    RestResponse<ChannelInventoryCountRespDto> queryChannelInventoryByCount(@RequestBody(required =false) ChannelInventoryCountReDto channelInventoryCountReDto);
}
