package com.dtyunxi.tcbj.api.dto.request;

import com.dtyunxi.dto.RequestDto;
import lombok.Getter;
import lombok.Setter;

import java.math.BigDecimal;
import java.util.Date;

/**
* 库存报表对比Eo对象
*
* @author fengjian
* @since 2022-07-07
*/
@Getter
@Setter
public class InventoryComparisonReportAddReqDto extends RequestDto {

    private Long id;
    /**
    *  统计时间
    */
    private Date statisticsTime;
    /**
    *  商品长编码
    */
    private String longCode;
    /**
    *  商品名称
    */
    private String cargoName;
    /**
    *  批次
    */
    private String batch;
    /**
    *  逻辑仓编码
    */
    private String warehouseCode;
    /**
    *  逻辑仓名称
    */
    private String warehouseName;
    /**
    *  组织ID
    */
    private Long organizationId;
    /**
    *  库存组织
    */
    private String organizationName;
    /**
    *  码拖数量
    */
    private Long trayNum;
    /**
    *  pcp库存
    */
    private BigDecimal balance;
    /**
    *  eas库存
    */
    private BigDecimal easNum;
    /**
    *  wms库存
    */
    private BigDecimal wmsNum;
    /**
    *  pcp_eas差异
    */
    private BigDecimal pcpEas;
    /**
    *  pcp_wms差异
    */
    private BigDecimal pcpWms;
    /**
    *  eas_wms差异
    */
    private BigDecimal easWms;
    /**
    *  是否存在差异 1:是,0:否;
    */
    private Integer diff;

}
