/**
 * @(#) GetInventoryDetailReportListPageParams.java 1.0 2022/1/5/005 Copyright (c) 2018, YUNXI. All rights
 *         reserved. YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.tcbj.api.dto.request;

import com.dtyunxi.dto.BasePageDto;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.validation.constraints.NotNull;
import lombok.Data;

import java.util.List;

/**
 * GetInventoryDetailReportListPageParams
 */
@Data
@ApiModel(value = "InventoryComparisonReqDto", description = "")
public class InventoryComparisonReqDto extends BasePageDto {

  @NotNull
  @ApiModelProperty(name = "pageSize", required = true, value = "")
  @JsonProperty("pageSize")
  private Integer pageSize;

  @NotNull
  @ApiModelProperty(name = "pageNum", required = true, value = "")
  @JsonProperty("pageNum")
  private Integer pageNum;


  @ApiModelProperty(name = "statisticsTimeStart", value = "对比时间开始")
  @JsonProperty("statisticsTimeStart")
  private String statisticsTimeStart;


  @ApiModelProperty(name = "statisticsTimeEnd", value = "对比时间结束")
  @JsonProperty("statisticsTimeEnd")
  private String statisticsTimeEnd;


  @ApiModelProperty(name = "goodsLongCode", value = "商品长编码")
  @JsonProperty("goodsLongCode")
  private String goodsLongCode;


  @ApiModelProperty(name = "goodsName", value = "商品名称")
  @JsonProperty("goodsName")
  private String goodsName;


  @ApiModelProperty(name = "batch", value = "批次")
  @JsonProperty("batch")
  private String batch;


  @ApiModelProperty(name = "logicalWarehouseCode", value = "逻辑仓编码")
  @JsonProperty("logicalWarehouseCode")
  private String logicalWarehouseCode;

  @ApiModelProperty(name = "logicalWarehouseCodeList", value = "逻辑仓编码")
  @JsonProperty("logicalWarehouseCodeList")
  private List<String> logicalWarehouseCodeList;


  @ApiModelProperty(name = "logicalWarehouseName", value = "逻辑仓名称")
  @JsonProperty("logicalWarehouseName")
  private String logicalWarehouseName;


  @ApiModelProperty(name = "cargoRightName", value = "库存组织名称")
  @JsonProperty("cargoRightName")
  private String cargoRightName;

  @ApiModelProperty(name = "diff", value = "是否存在差异，1:是;0:否")
  @JsonProperty("diff")
  private Integer diff;

  @ApiModelProperty(name = "PCPAndEASDiff", value = "PCP、EAS是否存在差异，1:是;0:否")
  @JsonProperty("PCPAndEASDiff")
  private Integer PCPAndEASDiff;

  @ApiModelProperty(name = "PCPAndWMSDiff", value = "PCP、WMS是否存在差异，1:是;0:否")
  @JsonProperty("PCPAndWMSDiff")
  private Integer PCPAndWMSDiff;

  @ApiModelProperty(name = "EASAndWMSDiff", value = "EAS、WMS是否存在差异，1:是;0:否")
  @JsonProperty("EASAndWMSDiff")
  private Integer EASAndWMSDiff;

  @ApiModelProperty(name = "logicalWarehouseFilter", value = "是否开启逻辑仓过滤，1:是;0:否")
  @JsonProperty("logicalWarehouseFilter")
  private Integer logicalWarehouseFilter;

  private Integer version;

  @ApiModelProperty(name = "refWarehouseCodeList", value = "物理仓编码")
  private List<String> refWarehouseCodeList;

  @ApiModelProperty(name = "refWarehouseNameList", value = "物理仓")
  private List<String> refWarehouseNameList;

  @ApiModelProperty(name = "warehouseClassifyList", value = "逻辑仓分类")
  private List<String> warehouseClassifyList;

  @ApiModelProperty(name = "warehouseQualityList", value = "逻辑仓品质")
  private List<String> warehouseQualityList;



}

