package com.dtyunxi.tcbj.api.dto.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * @author minyue
 * @description: 经销商报表-产品排名
 * @since 2022-01-06 10:07
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "OrderItemProductRankingReqDto", description = "产品排名入参")
public class OrderItemProductRankingReqDto extends ReportBaseReqDto {

    @ApiModelProperty(name = "placeTimeStart", value = "时间起(年月日)")
    private String placeTimeStart;

    @ApiModelProperty(name = "placeTimeEnd", value = "时间(年月日)")
    private String placeTimeEnd;

    @ApiModelProperty(name = "itemType", value = "商品类型")
    private String itemType;

    @ApiModelProperty(name = "itemName", value = "商品名称")
    private String itemName;

    @ApiModelProperty(name = "orderType", value = "订单类型(1:订单，2：售后单)")
    @NotNull
    private Integer orderType;

    @ApiModelProperty(name = "orderTradeStatus", value = "销售出库单状态/退货入库单状态")
    private List<String> orderTradeStatus;

}
